/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverterManager;
import java.util.ArrayList;
import java.util.Collection;

public class CharacterArrayConverter
implements TypeConverter<char[]> {
    protected final TypeConverterManager typeConverterManager;

    public CharacterArrayConverter(TypeConverterManager typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    @Override
    public char[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected char convertType(Object value) {
        return this.typeConverterManager.convertType(value, Character.TYPE).charValue();
    }

    protected char[] convertToSingleElementArray(Object value) {
        return new char[]{this.convertType(value)};
    }

    protected char[] convertValueToArray(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            char[] target = new char[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<Character> charArrayList = new ArrayList<Character>();
            for (Object element : iterable) {
                char convertedValue = this.convertType(element);
                charArrayList.add(Character.valueOf(convertedValue));
            }
            char[] array = new char[charArrayList.size()];
            for (int i = 0; i < charArrayList.size(); ++i) {
                Character c = (Character)charArrayList.get(i);
                array[i] = c.charValue();
            }
            return array;
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            char[] result = new char[charSequence.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = charSequence.charAt(i);
            }
            return result;
        }
        return this.convertToSingleElementArray(value);
    }

    protected char[] convertArrayToArray(Object value) {
        char[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new char[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected char[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        char[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == Character.TYPE) {
                                        return (char[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new char[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = (char)array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new char[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = (char)array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new char[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (char)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Double.TYPE) break block12;
                        double[] array = (double[])value;
                        result = new char[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = (char)array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Short.TYPE) break block13;
                    short[] array = (short[])value;
                    result = new char[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = (char)array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Byte.TYPE) break block14;
                byte[] array = (byte[])value;
                result = new char[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = (char)array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new char[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = (char)(array[i] ? 1 : 0);
            }
        }
        return result;
    }
}

