/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.util.StringPool;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import com.hypherionmc.simplerpc.jodd.util.Wildcard;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

public class StringTemplateMatcher {
    private static final Match[] NO_MATCH = new Match[0];
    public static final String DEFAULT_MACRO_PREFIX = "{";
    public static final String DEFAULT_MACRO_SPLIT = ":";
    public static final String DEFAULT_MACRO_END = "}";
    private String prefix = "{";
    private String split = ":";
    private String suffix = "}";
    private final String pattern;
    private final BiFunction<Integer, String, Boolean> REGEX = new BiFunction<Integer, String, Boolean>(){
        private Pattern[] regexpPattern;

        @Override
        public Boolean apply(Integer macroIndex, String value) {
            if (this.regexpPattern == null) {
                this.regexpPattern = new Pattern[StringTemplateMatcher.this.compiled.macrosCount];
            }
            if (this.regexpPattern[macroIndex] == null) {
                this.regexpPattern[macroIndex.intValue()] = Pattern.compile(StringTemplateMatcher.this.compiled.patterns[macroIndex]);
            }
            return this.regexpPattern[macroIndex].matcher(value).matches();
        }
    };
    private final BiFunction<Integer, String, Boolean> WILDCARD = new BiFunction<Integer, String, Boolean>(){

        @Override
        public Boolean apply(Integer macroIndex, String value) {
            return Wildcard.matchPath(value, StringTemplateMatcher.this.compiled.patterns[macroIndex]);
        }
    };
    private BiFunction<Integer, String, Boolean> matchValue = this.REGEX;
    private StringTemplateMatcherCompiled compiled;

    public static StringTemplateMatcher of(String pattern) {
        return new StringTemplateMatcher(pattern);
    }

    public StringTemplateMatcher(String pattern) {
        this.pattern = pattern;
    }

    public StringTemplateMatcher setMacroPrefix(String prefix) {
        this.prefix = Objects.requireNonNull(prefix);
        this.compiled = null;
        return this;
    }

    public StringTemplateMatcher setMacroSuffix(String suffix) {
        this.suffix = Objects.requireNonNull(suffix);
        this.compiled = null;
        return this;
    }

    public StringTemplateMatcher setMacroSplit(String split) {
        this.split = Objects.requireNonNull(split);
        this.compiled = null;
        return this;
    }

    public StringTemplateMatcher useWildcardMatch() {
        this.matchValue = this.WILDCARD;
        return this;
    }

    public StringTemplateMatcher useRegexMatch() {
        this.matchValue = this.REGEX;
        return this;
    }

    public StringTemplateMatcherCompiled compile() {
        int[] ndx;
        if (this.compiled != null) {
            return this.compiled;
        }
        int macrosCount = StringUtil.count(this.pattern, this.prefix);
        if (macrosCount == 0) {
            return new StringTemplateMatcherCompiled();
        }
        this.compiled = new StringTemplateMatcherCompiled(macrosCount);
        int offset = 0;
        int i = 0;
        while ((ndx = StringUtil.indexOfRegion(this.pattern, this.prefix, this.suffix, offset)) != null) {
            ((StringTemplateMatcherCompiled)this.compiled).fixed[i] = this.pattern.substring(offset, ndx[0]);
            String name = this.pattern.substring(ndx[1], ndx[2]);
            String pattern = null;
            int colonNdx = name.indexOf(this.split);
            if (colonNdx != -1) {
                pattern = name.substring(colonNdx + 1).trim();
                name = name.substring(0, colonNdx).trim();
            }
            ((StringTemplateMatcherCompiled)this.compiled).patterns[i] = pattern;
            ((StringTemplateMatcherCompiled)this.compiled).names[i] = name;
            offset = ndx[3];
            ++i;
        }
        ((StringTemplateMatcherCompiled)this.compiled).fixed[i] = offset < this.pattern.length() ? this.pattern.substring(offset) : "";
        return this.compiled;
    }

    public boolean hasMacros() {
        return this.compile().macrosCount != 0;
    }

    public boolean matches(String input) {
        return this.compile().matches(input);
    }

    public Match[] match(String input) {
        return this.compile().match(input);
    }

    public class StringTemplateMatcherCompiled {
        private final int macrosCount;
        private final String[] names;
        private final String[] patterns;
        private final String[] fixed;

        private StringTemplateMatcherCompiled(int macrosCount) {
            this.macrosCount = macrosCount;
            this.names = new String[macrosCount];
            this.patterns = new String[macrosCount];
            this.fixed = new String[macrosCount + 1];
        }

        private StringTemplateMatcherCompiled() {
            this.macrosCount = 0;
            this.fixed = StringPool.EMPTY_ARRAY;
            this.patterns = StringPool.EMPTY_ARRAY;
            this.names = this.patterns;
        }

        public String[] names() {
            return this.names;
        }

        public String[] patterns() {
            return this.patterns;
        }

        public int macrosCount() {
            return this.macrosCount;
        }

        public boolean matches(String input) {
            String[] values = this.process(input, true);
            return values != null;
        }

        public Match[] match(String input) {
            String[] values = this.process(input, false);
            if (values == null) {
                return NO_MATCH;
            }
            Match[] matches = new Match[this.macrosCount];
            int valuesLength = values.length;
            for (int i = 0; i < valuesLength; ++i) {
                matches[i] = new Match(this.names[i], this.patterns[i], values[i]);
            }
            return matches;
        }

        private String[] process(String input, boolean match) {
            if (match && !input.startsWith(this.fixed[0])) {
                return null;
            }
            String[] values = new String[this.macrosCount];
            int offset = this.fixed[0].length();
            int i = 0;
            while (i < this.macrosCount) {
                String macroValue;
                String nextFixed;
                int nexti = i;
                do {
                    if (++nexti <= this.macrosCount) continue;
                    nextFixed = null;
                    break;
                } while ((nextFixed = this.fixed[nexti]).length() == 0);
                int ndx = nextFixed != null ? input.indexOf(nextFixed, offset) : input.length();
                if (ndx == -1) {
                    return null;
                }
                values[i] = macroValue = input.substring(offset, ndx);
                if (match && this.patterns[i] != null && !((Boolean)StringTemplateMatcher.this.matchValue.apply(i, macroValue)).booleanValue()) {
                    return null;
                }
                if (nextFixed == null) {
                    offset = ndx;
                    break;
                }
                int nextFixedLength = nextFixed.length();
                offset = ndx + nextFixedLength;
                i = nexti;
            }
            if (offset != input.length()) {
                return null;
            }
            return values;
        }
    }

    public static class Match {
        private final String name;
        private final String pattern;
        private final String value;

        public Match(String name, String pattern, String value) {
            this.name = name;
            this.pattern = pattern;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String pattern() {
            return this.pattern;
        }

        public String value() {
            return this.value;
        }
    }
}

