/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.client.stylisheffects.v1.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientAbstractions;
import fuzs.stylisheffects.client.gui.effects.EffectWidget;
import fuzs.stylisheffects.client.gui.effects.RenderAreasProvider;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.client.util.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_485;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffectRenderer
implements EffectWidget,
RenderAreasProvider {
    public static final double DEFAULT_WIDGET_SCALE = 4.0;
    protected static final class_2960 EFFECT_BACKGROUND = new class_2960("stylisheffects", "textures/gui/mob_effect_background.png");
    private final EffectRendererEnvironment environment;
    protected Object screen;
    private int availableWidth;
    private int availableHeight;
    private int startX;
    private int startY;
    private MobEffectWidgetContext.ScreenSide screenSide;
    protected List<class_1293> activeEffects;

    protected AbstractEffectRenderer(EffectRendererEnvironment environment) {
        this.environment = environment;
    }

    public void setScreenDimensions(Object screen, int availableWidth, int availableHeight, int startX, int startY, MobEffectWidgetContext.ScreenSide screenSide) {
        this.screen = screen;
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.startX = startX;
        this.startY = startY;
        this.screenSide = screenSide;
        switch (this.environment) {
            case GUI: {
                this.screenSide = this.screenSide.inverse();
                this.availableWidth -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.availableHeight -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                this.startX += (this.screenSide.right() ? 1 : -1) * ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.startY += ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                break;
            }
            case INVENTORY: {
                this.availableWidth -= ((ClientConfig.InventoryRendererConfig)this.rendererConfig()).screenBorderDistance;
            }
        }
    }

    public final void setActiveEffects(Collection<class_1293> activeEffects) {
        if (activeEffects.isEmpty()) {
            this.activeEffects = null;
            return;
        }
        this.activeEffects = activeEffects.stream().filter(this::isEffectAllowedToShow).sorted().collect(Collectors.toList());
    }

    private boolean isEffectAllowedToShow(class_1293 mobEffectInstance) {
        if (mobEffectInstance.method_48559() && this.rendererConfig().hideInfiniteEffects) {
            return false;
        }
        if (!mobEffectInstance.method_5592() && this.rendererConfig().respectHideParticles) {
            return false;
        }
        return ClientAbstractions.INSTANCE.isMobEffectVisibleIn(this.environment, mobEffectInstance);
    }

    public final boolean isActive() {
        return this.activeEffects != null && !this.activeEffects.isEmpty();
    }

    public final boolean isValid() {
        return !this.rendererConfig().allowFallback || this.getMaxRows() > 0 && this.getMaxColumns() > 0;
    }

    public final double getWidgetScale() {
        return this.rendererConfig().scale / 4.0;
    }

    public final int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getWidgetScale());
    }

    public final int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getWidgetScale());
    }

    public abstract MobEffectWidgetContext.Renderer getEffectRenderer();

    protected abstract int getBackgroundTextureX();

    protected abstract int getBackgroundTextureY();

    protected abstract int getSpriteOffsetX();

    protected abstract int getSpriteOffsetY(boolean var1);

    protected int getDurationOffsetX() {
        return this.getWidth() / 2;
    }

    protected int getDurationOffsetY() {
        return this.getHeight() - 10;
    }

    @Nullable
    public abstract EffectRendererEnvironment.Factory getFallbackRenderer();

    @Override
    public List<class_768> getRenderAreas() {
        return this.getEffectPositions(this.activeEffects).stream().map(Pair::getValue).map(pos -> new class_768(pos[0], pos[1], this.getScaledWidth(), this.getScaledHeight())).collect(Collectors.toList());
    }

    public List<Pair<class_1293, int[]>> getEffectPositions(List<class_1293> activeEffects) {
        ArrayList effectToPos = Lists.newArrayList();
        for (int counter = 0; counter < activeEffects.size(); ++counter) {
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            effectToPos.add(Pair.of((Object)activeEffects.get(counter), (Object)this.coordsToEffectPosition(posX, posY)));
        }
        return effectToPos;
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int[] coordsToEffectPosition(int coordX, int coordY) {
        int[] renderPositions = new int[2];
        switch (this.screenSide) {
            case LEFT: {
                renderPositions[0] = this.startX - (this.getScaledWidth() + 1) - (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
                break;
            }
            case RIGHT: {
                renderPositions[0] = this.startX + 1 + (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
            }
        }
        return renderPositions;
    }

    public void renderEffects(class_332 guiGraphics, class_310 minecraft) {
        for (Pair<class_1293, int[]> entry : this.getEffectPositions(this.activeEffects)) {
            this.renderWidget(guiGraphics, ((int[])entry.getValue())[0], ((int[])entry.getValue())[1], minecraft, (class_1293)entry.getKey());
        }
    }

    protected float getBlinkingAlpha(class_1293 mobEffectInstance) {
        if (!mobEffectInstance.method_5591() && !mobEffectInstance.method_48559() && mobEffectInstance.method_5584() <= 200) {
            int duration = 10 - mobEffectInstance.method_5584() / 20;
            return class_3532.method_15363((float)((float)mobEffectInstance.method_5584() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)mobEffectInstance.method_5584() * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        return 1.0f;
    }

    private int getAvailableWidth() {
        return Math.min(this.availableWidth, this.rendererConfig().maxColumns * (this.getScaledWidth() + this.rendererConfig().widgetSpaceX));
    }

    private int getAvailableHeight() {
        return Math.min(this.availableHeight, this.rendererConfig().maxRows * (this.getScaledHeight() + this.rendererConfig().widgetSpaceY));
    }

    private int getMaxColumns() {
        return this.getAvailableWidth() / (this.getScaledWidth() + this.rendererConfig().widgetSpaceX);
    }

    public int getMaxClampedColumns() {
        return class_3532.method_15340((int)this.getMaxColumns(), (int)1, (int)this.rendererConfig().maxColumns);
    }

    private int getAdjustedHeight() {
        if (this.getRows() > this.getMaxClampedRows()) {
            return (this.getAvailableHeight() - this.getScaledHeight()) / Math.max(1, this.getRows() - 1);
        }
        return this.getScaledHeight() + this.rendererConfig().widgetSpaceY;
    }

    private int getMaxRows() {
        return this.getAvailableHeight() / (this.getScaledHeight() + this.rendererConfig().widgetSpaceY);
    }

    public int getMaxClampedRows() {
        return class_3532.method_15340((int)this.getMaxRows(), (int)1, (int)this.rendererConfig().maxRows);
    }

    public int getRows() {
        return this.splitByColumns(this.activeEffects.size());
    }

    protected int splitByColumns(int amountToSplit) {
        return (int)Math.ceil((float)amountToSplit / (float)this.getMaxClampedColumns());
    }

    protected ClientConfig.EffectRendererConfig rendererConfig() {
        return switch (this.environment) {
            default -> throw new IncompatibleClassChangeError();
            case EffectRendererEnvironment.INVENTORY -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer();
            case EffectRendererEnvironment.GUI -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer();
        };
    }

    protected abstract ClientConfig.EffectWidgetConfig widgetConfig();

    @Override
    public final void renderWidget(class_332 guiGraphics, int posX, int posY, class_310 minecraft, class_1293 mobEffectInstance) {
        RenderSystem.enableBlend();
        guiGraphics.method_51448().method_22903();
        double scale = this.getWidgetScale();
        if (scale != 1.0) {
            guiGraphics.method_51448().method_22905((float)scale, (float)scale, 1.0f);
            posX = (int)((double)posX / scale);
            posY = (int)((double)posY / scale);
        }
        this.drawWidgetBackground(guiGraphics, posX, posY, mobEffectInstance);
        this.drawEffectSprite(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectText(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectAmplifier(guiGraphics, posX, posY, mobEffectInstance);
        guiGraphics.method_51448().method_22909();
    }

    protected void drawWidgetBackground(class_332 guiGraphics, int posX, int posY, class_1293 mobEffectInstance) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.rendererConfig().widgetAlpha));
        int backgroundY = this.getBackgroundY(mobEffectInstance, this.widgetConfig().ambientBorder, this.widgetConfig().qualityBorder);
        guiGraphics.method_25290(EFFECT_BACKGROUND, posX, posY, (float)this.getBackgroundTextureX(), (float)(this.getBackgroundTextureY() + backgroundY * this.getHeight()), this.getWidth(), this.getHeight(), 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawEffectSprite(class_332 guiGraphics, int posX, int posY, class_310 minecraft, class_1293 mobEffectInstance) {
        if (this.drawCustomEffect(guiGraphics, posX, posY, mobEffectInstance)) {
            return;
        }
        float blinkingAlpha = this.widgetConfig().blinkingAlpha ? this.getBlinkingAlpha(mobEffectInstance) : 1.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.rendererConfig().widgetAlpha));
        class_1058 atlasSprite = minecraft.method_18505().method_18663(mobEffectInstance.method_5579());
        guiGraphics.method_25298(posX + this.getSpriteOffsetX(), posY + this.getSpriteOffsetY(!this.widgetConfig().ambientDuration && mobEffectInstance.method_5591()), 0, 18, 18, atlasSprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean drawCustomEffect(class_332 guiGraphics, int posX, int posY, class_1293 mobEffectInstance) {
        Object object = this.screen;
        if (object instanceof class_485) {
            class_485 effectInventoryScreen = (class_485)object;
            return ClientAbstractions.INSTANCE.renderInventoryIcon(mobEffectInstance, effectInventoryScreen, guiGraphics, posX, posY, 0);
        }
        object = this.screen;
        if (object instanceof class_329) {
            class_329 gui = (class_329)object;
            return ClientAbstractions.INSTANCE.renderGuiIcon(mobEffectInstance, gui, guiGraphics, posX, posY, 0.0f, this.getBlinkingAlpha(mobEffectInstance) * (float)this.rendererConfig().widgetAlpha);
        }
        return false;
    }

    protected void drawEffectText(class_332 guiGraphics, int posX, int posY, class_310 minecraft, class_1293 mobEffectInstance) {
        if (!this.widgetConfig().ambientDuration && mobEffectInstance.method_5591()) {
            return;
        }
        this.getEffectDuration(mobEffectInstance).ifPresent(durationComponent -> {
            int potionColor = ColorUtil.getEffectColor(this.widgetConfig().durationColor, mobEffectInstance);
            int alpha = (int)(this.rendererConfig().widgetAlpha * 255.0) << 24;
            class_5481 text = durationComponent.method_30937();
            int offsetX = this.getDurationOffsetX();
            int offsetY = this.getDurationOffsetY();
            guiGraphics.method_51430(minecraft.field_1772, text, posX + offsetX - 1 - minecraft.field_1772.method_30880(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.method_51430(minecraft.field_1772, text, posX + offsetX + 1 - minecraft.field_1772.method_30880(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.method_51430(minecraft.field_1772, text, posX + offsetX - minecraft.field_1772.method_30880(text) / 2, posY + offsetY - 1, alpha, false);
            guiGraphics.method_51430(minecraft.field_1772, text, posX + offsetX - minecraft.field_1772.method_30880(text) / 2, posY + offsetY + 1, alpha, false);
            guiGraphics.method_51430(minecraft.field_1772, text, posX + offsetX - minecraft.field_1772.method_30880(text) / 2, posY + offsetY, alpha | potionColor, false);
        });
    }

    protected void drawEffectAmplifier(class_332 guiGraphics, int posX, int posY, class_1293 mobEffectInstance) {
    }

    protected int getBackgroundY(class_1293 mobEffectInstance, boolean showAmbient, boolean showQuality) {
        if (showAmbient && mobEffectInstance.method_5591()) {
            return 1;
        }
        if (showQuality) {
            return mobEffectInstance.method_5579().method_5573() ? 2 : 3;
        }
        return 0;
    }

    protected final Optional<class_2561> getEffectDuration(class_1293 mobEffectInstance) {
        if (this.isInfiniteDuration(mobEffectInstance)) {
            return Optional.ofNullable(this.getInfiniteDurationString()).map(class_2561::method_43470);
        }
        return Optional.of(class_2561.method_43470((String)this.formatEffectDuration(mobEffectInstance)));
    }

    @Nullable
    protected String getInfiniteDurationString() {
        return "\u221e";
    }

    protected boolean isInfiniteDuration(class_1293 mobEffectInstance) {
        return mobEffectInstance.method_5584() >= 72000 || mobEffectInstance.method_48559();
    }

    protected String formatEffectDuration(class_1293 mobEffectInstance) {
        return AbstractEffectRenderer.formatTickDuration(mobEffectInstance.method_5584());
    }

    public static String formatTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        if (hours > 0) {
            return String.format(Locale.ROOT, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%d:%02d", minutes, seconds);
    }

    public static String formatCompactTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        int days = hours / 24;
        seconds %= 60;
        minutes %= 60;
        hours %= 24;
        if (days > 0) {
            return days + "d";
        }
        if (hours > 0) {
            return hours + "h";
        }
        if (minutes > 0) {
            return minutes + "m";
        }
        return seconds + "s";
    }

    public Optional<List<class_2561>> getHoveredEffectTooltip(int mouseX, int mouseY, class_1836 tooltipFlag) {
        if (this.environment == EffectRendererEnvironment.INVENTORY && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().hoveringTooltip) {
            return this.getHoveredEffect(mouseX, mouseY).map(mobEffectInstance -> {
                List<class_2561> tooltipLines = this.makeEffectTooltip((class_1293)mobEffectInstance, ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().tooltipDuration);
                ClientAbstractions.INSTANCE.onGatherEffectTooltipLines(this.buildContext((class_1293)mobEffectInstance), tooltipLines, tooltipFlag);
                return tooltipLines;
            });
        }
        return Optional.empty();
    }

    public MobEffectWidgetContext buildContext(class_1293 mobEffectInstance) {
        return MobEffectWidgetContext.of(mobEffectInstance, this.getEffectRenderer(), this.screenSide);
    }

    public Optional<class_1293> getHoveredEffect(int mouseX, int mouseY) {
        for (Map.Entry entry : Lists.reverse(this.getEffectPositions(this.activeEffects))) {
            if (!this.isMouseOver(((int[])entry.getValue())[0], ((int[])entry.getValue())[1], mouseX, mouseY)) continue;
            return Optional.of((class_1293)entry.getKey());
        }
        return Optional.empty();
    }

    private boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return mouseX >= posX && mouseX <= posX + this.getScaledWidth() && mouseY >= posY && mouseY <= posY + this.getScaledHeight();
    }

    protected List<class_2561> makeEffectTooltip(class_1293 mobEffectInstance, boolean withDuration) {
        ArrayList tooltip = Lists.newArrayList();
        class_5250 textComponent = this.getEffectDisplayName(mobEffectInstance);
        if (withDuration && !mobEffectInstance.method_48559()) {
            textComponent.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43470((String)"(").method_27693(AbstractEffectRenderer.formatTickDuration(mobEffectInstance.method_5584())).method_27693(")").method_27692(class_124.field_1080));
        }
        tooltip.add(textComponent);
        String descriptionKey = mobEffectInstance.method_5579().method_5567() + ".description";
        if (class_2477.method_10517().method_4678(descriptionKey)) {
            tooltip.add(class_2561.method_43471((String)descriptionKey).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    protected class_5250 getEffectDisplayName(class_1293 mobEffectInstance) {
        class_5250 textComponent = class_2561.method_43473().method_10852(mobEffectInstance.method_5579().method_5560());
        String translationKey = "enchantment.level." + (mobEffectInstance.method_5578() + 1);
        if (mobEffectInstance.method_5578() >= 1 && mobEffectInstance.method_5578() <= 9 || class_2477.method_10517().method_4678(translationKey)) {
            textComponent.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)translationKey));
        }
        return textComponent;
    }
}

