/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.handler;

import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.client.stylisheffects.v1.EffectScreenHandler;
import fuzs.stylisheffects.api.client.stylisheffects.v1.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientAbstractions;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiSmallEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryFullSizeEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.config.ClientConfig;
import fuzs.stylisheffects.mixin.client.accessor.AbstractContainerMenuAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_518;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EffectScreenHandlerImpl
implements EffectScreenHandler {
    public static final EffectScreenHandlerImpl INSTANCE = new EffectScreenHandlerImpl();
    @Nullable
    private AbstractEffectRenderer guiRenderer;
    @Nullable
    private AbstractEffectRenderer inventoryRenderer;

    private EffectScreenHandlerImpl() {
    }

    @Override
    public void rebuildEffectRenderers() {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE) {
            this.guiRenderer = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.GUI);
        }
    }

    @Override
    public Optional<MobEffectWidgetContext> getInventoryHoveredEffect(class_437 screen, double mouseX, double mouseY) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).flatMap(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).map(renderer::buildContext));
    }

    @Override
    public List<class_768> getInventoryRenderAreas(class_437 screen) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).map(AbstractEffectRenderer::getRenderAreas).orElse(List.of());
    }

    public void onClientTick(class_310 minecraft) {
        this.createInventoryRenderer(minecraft.field_1755, (class_1657)minecraft.field_1724);
    }

    public void onAfterInit(class_310 minecraft, class_437 screen, int screenWidth, int screenHeight, List<class_339> widgets, Consumer<class_339> addWidget, Consumer<class_339> removeWidget) {
        this.createInventoryRenderer(screen, (class_1657)minecraft.field_1724);
    }

    private void createInventoryRenderer(@Nullable class_437 screen, @Nullable class_1657 player) {
        AbstractEffectRenderer renderer;
        AbstractEffectRenderer abstractEffectRenderer = renderer = screen != null ? EffectScreenHandlerImpl.createInventoryRendererOrFallback(screen) : null;
        if (renderer != null && player != null) {
            renderer.setActiveEffects(player.method_6026());
        }
        this.inventoryRenderer = renderer;
    }

    public EventResult onRenderMobEffectIconsOverlay(class_310 minecraft, class_332 guiGraphics, float tickDelta, int screenWidth, int screenHeight) {
        if (ModLoaderEnvironment.INSTANCE.isForge() && minecraft.field_1690.field_1866) {
            return EventResult.INTERRUPT;
        }
        EffectScreenHandlerImpl.getEffectRenderer(minecraft.field_1755, true, this.guiRenderer, minecraft.field_1724.method_6026()).ifPresent(renderer -> {
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().screenSide;
            renderer.setScreenDimensions(minecraft.field_1705, screenWidth, screenHeight, screenSide.right() ? screenWidth : 0, 0, screenSide);
            renderer.renderEffects(guiGraphics, minecraft);
        });
        return EventResult.INTERRUPT;
    }

    public void onDrawBackground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = ScreenHelper.INSTANCE.getMinecraft(screen);
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.renderEffects(guiGraphics, minecraft));
    }

    public void onDrawForeground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = ScreenHelper.INSTANCE.getMinecraft(screen);
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> {
            class_1836.class_1837 tooltipFlag = minecraft.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
            renderer.getHoveredEffectTooltip(mouseX, mouseY, (class_1836)tooltipFlag).ifPresent(tooltip -> {
                if (!screen.method_17577().method_34255().method_7960()) {
                    return;
                }
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22904((double)(-ScreenHelper.INSTANCE.getLeftPos(screen)), (double)(-ScreenHelper.INSTANCE.getTopPos(screen)), 0.0);
                guiGraphics.method_51434(ScreenHelper.INSTANCE.getFont((class_437)screen), tooltip, mouseX, mouseY);
                guiGraphics.method_51448().method_22909();
            });
        });
    }

    public EventResult onMouseClicked(class_437 screen, double mouseX, double mouseY, int button) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).ifPresent(effectInstance -> ClientAbstractions.INSTANCE.onEffectMouseClicked(renderer.buildContext((class_1293)effectInstance), screen, mouseX, mouseY, button)));
        return EventResult.PASS;
    }

    public EventResult onScreenOpen(@Nullable class_437 oldScreen, DefaultedValue<class_437> newScreen) {
        Object object = newScreen.get();
        if (object instanceof class_465) {
            class_3917<?> type;
            class_465 containerScreen = (class_465)object;
            if (((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().debugContainerTypes && (type = ((AbstractContainerMenuAccessor)containerScreen.method_17577()).getMenuType()) != null) {
                class_5250 component = class_2561.method_43470((String)class_7923.field_41187.method_10221(type).toString());
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"debug.menu.opening", (Object[])new Object[]{class_2564.method_10885((class_2561)component)}));
            }
        }
        return EventResult.PASS;
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(class_437 screen, @Nullable AbstractEffectRenderer effectRenderer) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, false, effectRenderer, null);
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(@Nullable class_437 screen, boolean invertSupport, @Nullable AbstractEffectRenderer effectRenderer, @Nullable Collection<class_1293> activeEffects) {
        if ((!invertSupport && EffectScreenHandlerImpl.supportsEffectsDisplay(screen) || invertSupport && !EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) && effectRenderer != null) {
            if (activeEffects != null) {
                effectRenderer.setActiveEffects(activeEffects);
            }
            if (effectRenderer.isActive()) {
                return Optional.of(effectRenderer);
            }
        }
        return Optional.empty();
    }

    public static AbstractEffectRenderer createRenderer(MobEffectWidgetContext.Renderer renderer, EffectRendererEnvironment environment) {
        return switch (renderer) {
            case MobEffectWidgetContext.Renderer.GUI_SMALL -> new GuiSmallEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.GUI_COMPACT -> new GuiCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_COMPACT -> new InventoryCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_FULL_SIZE -> new InventoryFullSizeEffectRenderer(environment);
            default -> throw new IllegalArgumentException(String.format("Cannot create effect renderer for type %s", new Object[]{renderer}));
        };
    }

    @Nullable
    private static AbstractEffectRenderer createInventoryRendererOrFallback(class_437 screen) {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE && EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) {
            class_465 containerScreen = (class_465)screen;
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide;
            Consumer<AbstractEffectRenderer> setScreenDimensions = renderer -> {
                int leftPos = ScreenHelper.INSTANCE.getLeftPos(containerScreen);
                renderer.setScreenDimensions(containerScreen, !screenSide.right() ? leftPos : containerScreen.field_22789 - (leftPos + ScreenHelper.INSTANCE.getImageWidth(containerScreen)), ScreenHelper.INSTANCE.getImageHeight(containerScreen), !screenSide.right() ? leftPos : leftPos + ScreenHelper.INSTANCE.getImageWidth(containerScreen), ScreenHelper.INSTANCE.getTopPos(containerScreen), screenSide);
            };
            AbstractEffectRenderer renderer2 = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.INVENTORY);
            setScreenDimensions.accept(renderer2);
            while (!renderer2.isValid()) {
                EffectRendererEnvironment.Factory rendererFactory = renderer2.getFallbackRenderer();
                if (rendererFactory == null) {
                    return null;
                }
                renderer2 = (AbstractEffectRenderer)rendererFactory.apply(EffectRendererEnvironment.INVENTORY);
                setScreenDimensions.accept(renderer2);
            }
            return renderer2;
        }
        return null;
    }

    private static boolean supportsEffectsDisplay(@Nullable class_437 screen) {
        class_465 containerScreen;
        class_3917<?> type;
        if (screen instanceof class_465 && (type = ((AbstractContainerMenuAccessor)(containerScreen = (class_465)screen).method_17577()).getMenuType()) != null && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().menuBlacklist.contains(type)) {
            return false;
        }
        if (screen instanceof class_485 || ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().effectsEverywhere && screen instanceof class_465) {
            class_518 listener;
            if (screen instanceof class_518 && (listener = (class_518)screen).method_2659().method_2605()) {
                return ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide.right();
            }
            return true;
        }
        return false;
    }
}

