/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.platform;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.networking.Packet;
import einstein.subtle_effects.platform.services.NetworkHelper;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkHelper
implements NetworkHelper {
    @Override
    public <T extends Packet> boolean sendToServer(T t) {
        return FabricNetworkHelper.send(t, ClientPlayNetworking.canSend((class_2960)t.id()), ClientPlayNetworking::send);
    }

    @Override
    public <T extends Packet> boolean sendToClient(T t, class_3222 player) {
        return FabricNetworkHelper.send(t, ServerPlayNetworking.canSend((class_3222)player, (class_2960)t.id()), (id, buf) -> ServerPlayNetworking.send((class_3222)player, (class_2960)id, (class_2540)buf));
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(class_3218 level, class_2338 pos, T t) {
        this.sendToClientsTracking(null, level, pos, t);
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(@Nullable class_3222 exceptPlayer, class_3218 level, class_2338 pos, T t) {
        this.sendToClientsTracking(exceptPlayer, level, pos, t, player -> {});
    }

    @Override
    public <T extends Packet> void sendToClientsTracking(@Nullable class_3222 exceptPlayer, class_3218 level, class_2338 pos, T t, @Nullable Consumer<class_3222> skippedPlayerConsumer) {
        PlayerLookup.tracking((class_3218)level, (class_2338)pos).forEach(player -> {
            if (!player.equals((Object)exceptPlayer) && !this.sendToClient(t, (class_3222)player) && skippedPlayerConsumer != null) {
                skippedPlayerConsumer.accept((class_3222)player);
            }
        });
    }

    private static <T extends Packet> boolean send(T t, boolean canSend, BiConsumer<class_2960, class_2540> consumer) {
        Class<?> packetClass = t.getClass();
        class_2960 id = t.id();
        if (canSend) {
            if (PACKETS.containsKey(packetClass)) {
                NetworkHelper.PacketData data = (NetworkHelper.PacketData)PACKETS.get(packetClass);
                class_2540 buf = PacketByteBufs.create();
                t.encode(buf);
                consumer.accept(data.id(), buf);
                return true;
            }
            SubtleEffects.LOGGER.warn("Failed to find packet named: {}", (Object)id);
        }
        return false;
    }

    public static void init(NetworkHelper.Direction directionToRegister) {
        PACKETS.forEach((clazz, data) -> {
            if (data.direction() == directionToRegister) {
                if (directionToRegister == NetworkHelper.Direction.TO_CLIENT) {
                    ClientPlayNetworking.registerGlobalReceiver((class_2960)data.id(), (minecraft, handler, buf, responseSender) -> {
                        Packet packet = (Packet)data.decoder().apply(buf);
                        minecraft.execute(() -> packet.handle(null));
                    });
                } else if (directionToRegister == NetworkHelper.Direction.TO_SERVER) {
                    ServerPlayNetworking.registerGlobalReceiver((class_2960)data.id(), (server, player, handler, buf, responseSender) -> {
                        Packet packet = (Packet)data.decoder().apply(buf);
                        server.execute(() -> packet.handle(player));
                    });
                }
            }
        });
    }
}

