/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.geyser;

import einstein.subtle_effects.particle.option.GeyserSpoutParticleOptions;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.Ticker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserType;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5431;
import net.minecraft.class_5819;

public abstract class GeyserTicker
extends BlockPosTicker {
    protected final GeyserType type;
    protected final int lifeTime;
    protected int age;

    public GeyserTicker(GeyserType type, class_1937 level, class_2338 pos, class_5819 random) {
        super(level, random, pos);
        this.type = type;
        this.lifeTime = this.getTickDelay((Integer)type.activeTime.get());
        this.updateGeyserPositions(GeyserManager.ACTIVE_GEYSERS, list -> list.add(pos));
    }

    protected final void updateGeyserPositions(Map<GeyserType, List<class_2338>> map, Consumer<List<class_2338>> consumer) {
        if (!map.containsKey((Object)this.type)) {
            map.put(this.type, new ArrayList());
        }
        consumer.accept(map.get((Object)this.type));
    }

    public static void trySpawn(GeyserType type, class_1937 level, class_2338 pos, class_5819 random) {
        if (!(GeyserManager.ACTIVE_GEYSERS.containsKey((Object)type) && GeyserManager.ACTIVE_GEYSERS.get((Object)type).contains(pos) || GeyserManager.INACTIVE_GEYSERS.containsKey((Object)type) && GeyserManager.INACTIVE_GEYSERS.get((Object)type).contains(pos) || !GeyserTicker.checkLocation(type, level, pos, type.height))) {
            TickerManager.add((Ticker)type.geyserTickerProvider.apply((Object)level, (Object)pos, (Object)random));
        }
    }

    public static boolean checkLocation(GeyserType type, class_1937 level, class_2338 pos, int checkHeight) {
        class_2338 abovePos;
        if (GeyserTicker.isSpawnableBlock(type, level, pos, class_5431.field_25823) && GeyserTicker.canGeyserPassThrough(type, level, abovePos = pos.method_10084())) {
            if (checkHeight > 0) {
                for (int i = 1; i < checkHeight; ++i) {
                    if (GeyserTicker.canGeyserPassThrough(type, level, abovePos.method_10079(class_2350.field_11036, i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean canGeyserPassThrough(GeyserType type, class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_3610 fluidState = level.method_8316(pos);
        return !state.method_26206((class_1922)level, pos, class_2350.field_11033) && !(state.method_26204() instanceof class_4770) && (type.fluid != null ? fluidState.method_39360(type.fluid) && fluidState.method_15771() : fluidState.method_15769());
    }

    public static boolean isSpawnableBlock(GeyserType type, class_1937 level, class_2338 pos, class_5431 supportType) {
        class_2680 state = level.method_8320(pos);
        class_3610 fluidState = level.method_8316(pos);
        return type.spawnableBlocks.contains((Object)state.method_26204()) && state.method_30368((class_1922)level, pos, class_2350.field_11036, supportType) || type.spawnableBlocks.contains((Object)fluidState.method_15759().method_26204());
    }

    @Override
    public void positionedTick() {
        ++this.age;
        if (this.age >= this.lifeTime) {
            this.remove();
            return;
        }
        if (Util.isChunkLoaded(this.level, this.pos.method_10263(), this.pos.method_10260()) && GeyserTicker.checkLocation(this.type, this.level, this.pos, 0)) {
            if (this.age == 1 && GeyserTicker.isSpawnableBlock(this.type, this.level, this.pos, class_5431.field_25824)) {
                this.level.method_8406((class_2394)new GeyserSpoutParticleOptions(this.type.ordinal(), this.lifeTime), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 1.001, (double)this.pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            }
            this.geyserTick();
            return;
        }
        this.remove();
    }

    protected abstract void geyserTick();

    @Override
    public void remove() {
        super.remove();
        this.updateGeyserPositions(GeyserManager.ACTIVE_GEYSERS, list -> list.remove(this.pos));
        this.updateGeyserPositions(GeyserManager.INACTIVE_GEYSERS, list -> list.add(this.pos));
        TickerManager.schedule(this.getTickDelay((Integer)this.type.inactiveTime.get()), () -> this.updateGeyserPositions(GeyserManager.INACTIVE_GEYSERS, list -> list.remove(this.pos)));
    }

    private int getTickDelay(int max) {
        return max >= 300 ? class_3532.method_15395((class_5819)this.random, (int)(max - 200), (int)max) : max;
    }
}

