/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.recipe.RecipeTransformer;
import com.almostreliable.unified.utils.FileUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class RecipeDumper {
    private final RecipeTransformer.Result result;
    private final long startTime;
    private final long endTime;
    private final DateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public RecipeDumper(RecipeTransformer.Result result, long startTime, long endTime) {
        this.result = result;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void dump(boolean dumpOverview, boolean dumpUnify, boolean dumpDuplicate) {
        String last = "# Last execution: " + this.format.format(new Date(this.startTime));
        if (dumpOverview) {
            FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "overview_dump.txt", sb -> {
                sb.append(last).append("\n");
                this.dumpOverview((StringBuilder)sb);
            });
        }
        if (dumpUnify) {
            FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "unify_dump.txt", sb -> {
                sb.append(last).append("\n");
                this.dumpUnifyRecipes((StringBuilder)sb);
            });
        }
        if (dumpDuplicate) {
            FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "duplicates_dump.txt", sb -> {
                sb.append(last).append("\n");
                this.dumpDuplicates((StringBuilder)sb);
            });
        }
    }

    private void dumpDuplicates(StringBuilder stringBuilder) {
        this.getSortedUnifiedRecipeTypes().forEach(type -> {
            List<RecipeLink.DuplicateLink> duplicates = this.result.getDuplicates((class_2960)type).stream().sorted(Comparator.comparing(l -> l.getMaster().getId().toString())).toList();
            if (duplicates.isEmpty()) {
                return;
            }
            stringBuilder.append(duplicates.stream().map(this::createDuplicatesDump).collect(Collectors.joining("", type + " {\n", "}\n\n")));
        });
    }

    private String createDuplicatesDump(RecipeLink.DuplicateLink link) {
        return link.getRecipes().stream().sorted(Comparator.comparing(r -> r.getId().toString())).map(r -> "\t\t- " + r.getId() + "\n").collect(Collectors.joining("", String.format("\t%s\n", link.getMaster().getId().toString()), "\n"));
    }

    private void dumpOverview(StringBuilder stringBuilder) {
        stringBuilder.append("# Overview:\n").append("\t- Unified: ").append(this.result.getUnifiedRecipeCount()).append("\n").append("\t- Duplicates: ").append(this.result.getDuplicatesCount()).append(" (Individual: ").append(this.result.getDuplicateRecipesCount()).append(")\n").append("\t- Total Recipes: ").append(this.result.getRecipeCount()).append("\n").append("\t- Elapsed Time: ").append(this.getTotalTime()).append("ms").append("\n\n").append("# Summary: \n");
        stringBuilder.append(this.rf("Recipe type", 45)).append(" | ").append(this.lf("Unifies", 10)).append(" | ").append(this.lf("Duplicates", 10)).append(" | ").append(this.lf("All", 5)).append("\n").append(StringUtils.repeat((String)"-", (int)79)).append("\n");
        this.getSortedUnifiedRecipeTypes().forEach(type -> {
            int unifiedSize = this.result.getUnifiedRecipes((class_2960)type).size();
            int allSize = this.result.getRecipes((class_2960)type).size();
            int duplicatesSize = this.result.getDuplicates((class_2960)type).size();
            int individualDuplicatesSize = this.result.getDuplicates((class_2960)type).stream().mapToInt(l -> l.getRecipes().size()).sum();
            String dStr = String.format("%s (%s)", this.lf(duplicatesSize, 3), this.lf(individualDuplicatesSize, 3));
            stringBuilder.append(this.rf(type, 45)).append(" | ").append(this.lf(unifiedSize, 10)).append(" | ").append(this.lf(duplicatesSize == 0 ? " " : dStr, 10)).append(" | ").append(this.lf(allSize, 5)).append("\n");
        });
    }

    private void dumpUnifyRecipes(StringBuilder stringBuilder) {
        this.getSortedUnifiedRecipeTypes().forEach(type -> {
            stringBuilder.append(type.toString()).append(" {\n");
            this.getSortedUnifiedRecipes((class_2960)type).forEach(recipe -> stringBuilder.append("\t- ").append(recipe.getId()).append("\n").append("\t\t    Original: ").append(recipe.getOriginal().toString()).append("\n").append("\t\t Transformed: ").append(recipe.getUnified() == null ? "NOT UNIFIED" : recipe.getUnified().toString()).append("\n\n"));
            stringBuilder.append("}\n\n");
        });
    }

    private String rf(Object v, int size) {
        return StringUtils.rightPad((String)v.toString(), (int)size);
    }

    private String lf(Object v, int size) {
        return StringUtils.leftPad((String)v.toString(), (int)size);
    }

    private Stream<class_2960> getSortedUnifiedRecipeTypes() {
        return this.result.getUnifiedRecipeTypes().stream().sorted(Comparator.comparing(class_2960::toString));
    }

    private Stream<RecipeLink> getSortedUnifiedRecipes(class_2960 type) {
        return this.result.getUnifiedRecipes(type).stream().sorted(Comparator.comparing(r -> r.getId().toString()));
    }

    private long getTotalTime() {
        return this.endTime - this.startTime;
    }
}

