/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.InputEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IInputEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_5575;
import net.minecraft.class_636;
import net.minecraft.class_746;

public class ClientEvents {
    public static void init() {
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)ClientEvents::onClientTickEnd));
        ClientConnectionEvents.LOGGING_IN.register((IFrameworkEvent)((IClientConnectionEvent.LoggingIn)ClientEvents::onPlayerLogin));
        InputEvents.KEY.register((IFrameworkEvent)((IInputEvent.Key)ClientEvents::onKeyInput));
        InputEvents.CLICK.register((IFrameworkEvent)((IInputEvent.Click)ClientEvents::onInteraction));
    }

    private static void onPlayerLogin(class_746 player, class_636 gameMode, class_2535 connection) {
        Config.updateBannedItemsList();
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1755 == null) {
            class_746 player = mc.field_1724;
            if (Keys.KEY_BACKPACK.method_1434() && Keys.KEY_BACKPACK.method_1436() && !Services.BACKPACK.getBackpackStack((class_1657)player).method_7960()) {
                Network.getPlay().sendToServer((IMessage)new MessageOpenBackpack());
            }
        }
    }

    private static void onClientTickEnd() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        List players = mc.field_1687.method_18023((class_5575)class_1299.field_6097, mc.field_1724.method_5829().method_1014(16.0), player -> true);
        for (class_1657 player2 : players) {
            class_1799 stack;
            if (Services.BACKPACK.isBackpackVisible(player2) && !(stack = Services.BACKPACK.getBackpackStack(player2)).method_7960() && ClientEvents.canShowBackpackEffects(stack)) continue;
        }
    }

    public static boolean canShowBackpackEffects(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10573(ModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.method_10577(ModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    private static boolean onInteraction(boolean attack, boolean use, boolean pick, class_1268 hand) {
        if (!use || hand != class_1268.field_5808) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null || mc.field_1761 == null) {
            return false;
        }
        double range = (Double)Config.SERVER.pickpocketing.maxReachDistance.get();
        ArrayList entities = new ArrayList();
        if (((Boolean)Config.SERVER.pickpocketing.enabled.get()).booleanValue()) {
            entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_6097, mc.field_1724.method_5829().method_1014(range), player -> !Services.BACKPACK.getBackpackStack((class_1657)player).method_7960() && !player.equals((Object)mc.field_1724) && PickpocketUtil.canPickpocketEntity((class_1309)player, (class_1657)mc.field_1724)));
        }
        entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_17713, mc.field_1724.method_5829().method_1014((double)mc.field_1761.method_2904()), entity -> TraderPickpocketing.get((class_1297)entity).map(TraderPickpocketing::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((class_1309)entity, (class_1657)mc.field_1724, mc.field_1761.method_2904())));
        if (entities.isEmpty()) {
            return false;
        }
        class_243 start = mc.field_1724.method_5836(1.0f);
        class_243 end = mc.field_1724.method_5828(1.0f).method_1021((double)mc.field_1761.method_2904()).method_1019(start);
        double closestDistance = Double.MAX_VALUE;
        class_1309 hitEntity = null;
        for (class_1309 entity2 : entities) {
            double distance;
            class_238 box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.method_992(start, end);
            if (optionalHitVec.isEmpty() || !((distance = start.method_1022((class_243)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            if (PickpocketUtil.canSeeBackpack(hitEntity, (class_1657)mc.field_1724)) {
                Network.getPlay().sendToServer((IMessage)new MessageEntityBackpack(hitEntity.method_5628()));
                mc.field_1724.method_6104(hand);
            }
            return true;
        }
        return false;
    }
}

