/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class Backpack {
    private final Optional<Challenge> challenge;
    private class_2960 id;
    private class_2960 baseModel;
    private class_2960 strapsModel;
    private String translationKey;
    private boolean setup = false;

    public Backpack(Optional<Challenge> challenge) {
        this.challenge = challenge;
    }

    public Backpack(class_2540 buf) {
        class_2960 id = buf.method_10810();
        this.setup(id);
        this.challenge = buf.readBoolean() ? Optional.of(Challenge.DUMMY) : Optional.empty();
    }

    public class_2960 getId() {
        this.checkSetup();
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public class_2960 getBaseModel() {
        this.checkSetup();
        return this.baseModel;
    }

    public class_2960 getStrapsModel() {
        this.checkSetup();
        return this.strapsModel;
    }

    public boolean isUnlocked(class_1657 player) {
        return UnlockManager.getTracker(player).map(tracker -> tracker.isUnlocked(this.id)).orElse(false) != false || this.challenge.isEmpty() || (Boolean)Config.SERVER.backpack.unlockAllCosmetics.get() != false;
    }

    @Nullable
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return this.challenge.map(c -> c.createProgressTracker(backpackId)).orElse(null);
    }

    public void write(class_2540 buf) {
        this.checkSetup();
        buf.method_10812(this.id);
        buf.writeBoolean(this.challenge.isPresent());
    }

    public void setup(class_2960 id) {
        if (!this.setup) {
            this.id = id;
            String name = "backpacked/" + id.method_12832();
            this.baseModel = new class_2960(id.method_12836(), name);
            this.strapsModel = new class_2960(id.method_12836(), name + "_straps");
            this.translationKey = "backpack.%s.%s".formatted(id.method_12836(), id.method_12832());
            this.setup = true;
        }
    }

    private void checkSetup() {
        if (!this.setup) {
            throw new RuntimeException("Backpack is not setup");
        }
    }

    public static Backpack deserialize(JsonObject object) {
        if (object.has("unlock_challenge")) {
            return new Backpack(Challenge.deserialize(object.get("unlock_challenge")));
        }
        return new Backpack(Optional.empty());
    }
}

