/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FeedAnimalChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "feed_animal");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_2048> entity;
    private final int count;

    public FeedAnimalChallenge(ProgressFormatter formatter, Optional<class_2048> entity, int count) {
        super(ID);
        this.formatter = formatter;
        this.entity = entity;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.entity);
    }

    public static class Serializer
    extends ChallengeSerializer<FeedAnimalChallenge> {
        @Override
        public FeedAnimalChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.FED_X_OF_X);
            Optional<class_2048> predicate = object.has("animal") ? Optional.of(class_2048.method_8913((JsonElement)object.get("animal"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new FeedAnimalChallenge(formatter, predicate, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_2048> entityPredicate;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_2048> entityPredicate) {
            super(maxCount, formatter);
            this.entityPredicate = entityPredicate;
        }

        private boolean test(class_3222 player, class_1429 animal) {
            return this.entityPredicate.map(p -> p.method_8914(player, (class_1297)animal)).orElse(true);
        }

        public static void registerEvent() {
            BackpackedEvents.FEED_ANIMAL.register((animal, player) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    class_3222 serverPlayer = (class_3222)player;
                    if (!tracker.isComplete() && tracker.test(serverPlayer, animal)) {
                        tracker.increment(serverPlayer);
                    }
                });
            });
        }
    }
}

