/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4550;
import org.jetbrains.annotations.Nullable;

public class MineBlockChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "mine_block");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<class_4550> block;
    private final Optional<class_2073> item;
    private final int count;

    public MineBlockChallenge(ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.block = block;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.block, this.item);
    }

    public static class Serializer
    extends ChallengeSerializer<MineBlockChallenge> {
        @Override
        public MineBlockChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.MINED_X_OF_X);
            Optional<class_4550> block = object.has("block") ? Optional.of(class_4550.method_22453((JsonElement)object.get("block"))) : Optional.empty();
            Optional<class_2073> item = object.has("item") ? Optional.of(class_2073.method_8969((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new MineBlockChallenge(formatter, block, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_4550> block;
        private final Optional<class_2073> item;

        protected Tracker(int maxCount, ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
        }

        private boolean test(class_2680 state, class_1799 stack, @Nullable class_2487 tag) {
            return ChallengeUtils.testPredicate(this.block, state, tag) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.MINED_BLOCK_CAPTURE_TAG.register((state, stack, player) -> {
                if (player.method_37908().method_8608()) {
                    return false;
                }
                return UnlockManager.getTrackers(player, Tracker.class).stream().anyMatch(tracker -> !tracker.isComplete() && tracker.test(state, stack, null));
            });
            BackpackedEvents.MINED_BLOCK.register((state, stack, tag, player) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (!tracker.isComplete() && tracker.test(state, stack, tag)) {
                        tracker.increment((class_3222)player);
                    }
                });
            });
        }
    }
}

