/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.common.MovementType;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class TravelDistanceChallenge
extends Challenge {
    public static final class_2960 ID = new class_2960("backpacked", "travel_distance");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<EnumSet<MovementType>> movementTypes;
    private final int totalDistanceInCm;

    protected TravelDistanceChallenge(ProgressFormatter formatter, Optional<EnumSet<MovementType>> movementTypes, int totalDistanceInCm) {
        super(ID);
        this.formatter = formatter;
        this.movementTypes = movementTypes;
        this.totalDistanceInCm = totalDistanceInCm;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.formatter, this.movementTypes, this.totalDistanceInCm);
    }

    public static class Serializer
    extends ChallengeSerializer<TravelDistanceChallenge> {
        @Override
        public TravelDistanceChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.INT_PERCENT);
            Optional movements = object.has("movement") ? MovementType.LIST_CODEC.xmap(EnumSet::copyOf, List::copyOf).parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("movement")).result() : Optional.empty();
            int totalDistance = class_3518.method_15260((JsonObject)object, (String)"total_distance");
            if (totalDistance <= 0) {
                throw new JsonParseException("Total distance must be greater than zero. Found " + totalDistance);
            }
            return new TravelDistanceChallenge(formatter, movements, totalDistance);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<EnumSet<MovementType>> movementTypes;

        public Tracker(ProgressFormatter formatter, Optional<EnumSet<MovementType>> movementTypes, int maxCount) {
            super(maxCount, formatter);
            this.movementTypes = movementTypes;
        }

        public static void registerEvent() {
            BackpackedEvents.PLAYER_TRAVEL.register((player, distance, type) -> {
                int distanceInCm = Math.round((float)Math.sqrt(distance) * 100.0f);
                UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                    if (tracker.isComplete()) {
                        return;
                    }
                    if (tracker.movementTypes.map(types -> types.contains((Object)type)).orElse(true).booleanValue()) {
                        tracker.increment(distanceInCm, player);
                    }
                });
            });
        }
    }
}

