/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CraftingProgressTracker
implements IProgressTracker {
    protected int count;
    protected final int totalCount;
    private final ProgressFormatter formatter;
    protected final Predicate<class_1799> predicate;

    public CraftingProgressTracker(int totalCount, ProgressFormatter formatter, Predicate<class_1799> predicate) {
        this.totalCount = totalCount;
        this.formatter = formatter;
        this.predicate = predicate;
    }

    protected void processCrafted(class_1799 stack, class_3222 player) {
        if (this.predicate.test(stack)) {
            this.count += stack.method_7947();
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.count >= this.totalCount;
    }

    @Override
    public void read(class_2487 tag) {
        this.count = tag.method_10550("Count");
    }

    @Override
    public void write(class_2487 tag) {
        tag.method_10569("Count", this.count);
    }

    @Override
    public class_2561 getDisplayComponent() {
        return this.formatter.formatter().apply(this.count, this.totalCount);
    }

    public static void registerEvent() {
        PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)(player, stack, inventory) -> {
            if (player.method_37908().method_8608()) {
                return;
            }
            UnlockManager.getTrackers(player, CraftingProgressTracker.class).forEach(tracker -> {
                if (!tracker.isComplete()) {
                    tracker.processCrafted(stack, (class_3222)player);
                }
            });
        }));
    }
}

