/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CraftingProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class UniqueCraftingProgressTracker
extends CraftingProgressTracker {
    protected Set<class_2960> craftedItems = new HashSet<class_2960>();

    public UniqueCraftingProgressTracker(int totalCount, ProgressFormatter formatter, Predicate<class_1799> predicate) {
        super(totalCount, formatter, predicate);
    }

    @Override
    protected void processCrafted(class_1799 stack, class_3222 player) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (!this.craftedItems.contains(id) && this.predicate.test(stack)) {
            ++this.count;
            this.craftedItems.add(id);
            this.markForCompletionTest(player);
        }
    }

    @Override
    public void read(class_2487 tag) {
        super.read(tag);
        this.craftedItems.clear();
        class_2499 list = tag.method_10554("CraftedItems", 8);
        list.forEach(nbt -> {
            class_2960 id = class_2960.method_12829((String)nbt.method_10714());
            if (id != null) {
                this.craftedItems.add(id);
            }
        });
    }

    @Override
    public void write(class_2487 tag) {
        super.write(tag);
        class_2499 list = new class_2499();
        this.craftedItems.forEach(location -> list.add((Object)class_2519.method_23256((String)location.toString())));
        tag.method_10566("CraftedItems", (class_2520)list);
    }

    public static void registerEvent() {
        PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)(player, stack, inventory) -> {
            if (player.method_37908().method_8608()) {
                return;
            }
            UnlockManager.getTrackers(player, UniqueCraftingProgressTracker.class).forEach(tracker -> {
                if (!tracker.isComplete()) {
                    tracker.processCrafted(stack, (class_3222)player);
                }
            });
        }));
    }
}

