/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.util.Serializable;
import com.mrcrayfish.framework.api.sync.IDataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class UnlockTracker
extends SyncedObject
implements Serializable {
    public static final Serializer SERIALIZER = new Serializer();
    private final Set<class_2960> unlockedBackpacks = new HashSet<class_2960>();
    private final Map<class_2960, IProgressTracker> backpackToProgressTracker;
    private final Map<Class<?>, List<IProgressTracker>> classToProgressTrackers;

    public UnlockTracker() {
        HashMap backpackMap = new HashMap();
        HashMap classMap = new HashMap();
        BackpackManager.instance().getBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker(backpack.getId());
            if (tracker != null) {
                classMap.computeIfAbsent(tracker.getClass(), c -> new ArrayList()).add(tracker);
                backpackMap.put(backpack.getId(), tracker);
            }
        });
        this.backpackToProgressTracker = ImmutableMap.copyOf(backpackMap);
        this.classToProgressTrackers = ImmutableMap.copyOf(classMap);
    }

    public Set<class_2960> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<class_2960, IProgressTracker> getProgressTrackerMap() {
        return this.backpackToProgressTracker;
    }

    public boolean isUnlocked(class_2960 id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(class_2960 backpackId) {
        if (!((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue() && !this.unlockedBackpacks.contains(backpackId)) {
            return Optional.ofNullable(this.backpackToProgressTracker.get(backpackId));
        }
        return Optional.empty();
    }

    public <T> List<T> getProgressTrackers(Class<T> trackerClass) {
        if (this.classToProgressTrackers.containsKey(trackerClass)) {
            return this.classToProgressTrackers.get(trackerClass);
        }
        return Collections.emptyList();
    }

    public boolean unlockBackpack(class_2960 id) {
        if (BackpackManager.instance().getBackpack(id) != null && this.unlockedBackpacks.add(id)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        class_2499 unlockedBackpacks = new class_2499();
        this.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)class_2519.method_23256((String)location.toString())));
        tag.method_10566("UnlockedBackpacks", (class_2520)unlockedBackpacks);
        class_2499 progressTrackers = new class_2499();
        this.backpackToProgressTracker.forEach((location, progressTracker) -> {
            class_2487 progressTag = new class_2487();
            progressTag.method_10582("Id", location.toString());
            class_2487 dataTag = new class_2487();
            progressTracker.write(dataTag);
            progressTag.method_10566("Data", (class_2520)dataTag);
            progressTrackers.add((Object)progressTag);
        });
        tag.method_10566("ProgressTrackers", (class_2520)progressTrackers);
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        this.unlockedBackpacks.clear();
        class_2499 unlockedBackpacks = tag.method_10554("UnlockedBackpacks", 8);
        unlockedBackpacks.forEach(t -> this.unlockedBackpacks.add(class_2960.method_12829((String)t.method_10714())));
        class_2499 progressTrackers = tag.method_10554("ProgressTrackers", 10);
        progressTrackers.forEach(t -> {
            class_2487 progressTag = (class_2487)t;
            class_2960 id = new class_2960(progressTag.method_10558("Id"));
            IProgressTracker tracker = this.backpackToProgressTracker.get(id);
            if (tracker != null) {
                class_2487 dataTag = progressTag.method_10562("Data");
                tracker.read(dataTag);
            }
        });
    }

    public static class Serializer
    implements IDataSerializer<UnlockTracker> {
        public void write(class_2540 buf, UnlockTracker value) {
            buf.method_10794(value.serialize());
        }

        public UnlockTracker read(class_2540 buf) {
            UnlockTracker tracker = new UnlockTracker();
            Optional.ofNullable(buf.method_10798()).ifPresent(tracker::deserialize);
            return tracker;
        }

        public class_2520 write(UnlockTracker value) {
            return value.serialize();
        }

        public UnlockTracker read(class_2520 nbt) {
            UnlockTracker tracker = new UnlockTracker();
            if (nbt instanceof class_2487) {
                class_2487 tag = (class_2487)nbt;
                tracker.deserialize(tag);
            }
            return tracker;
        }
    }
}

