/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.common;

import com.mrcrayfish.backpacked.common.MovementType;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.event.BackpackedInteractAccess;
import com.mrcrayfish.backpacked.event.entity.InteractedWithEntity;
import com.mrcrayfish.backpacked.event.entity.PlayerTravel;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMixin
implements BackpackedInventoryAccess {
    @Unique
    public BackpackInventory backpacked$Inventory = null;

    @Override
    @Nullable
    public BackpackInventory backpacked$GetBackpackInventory() {
        class_1657 player = (class_1657)this;
        class_1799 stack = Services.BACKPACK.getBackpackStack(player);
        if (stack.method_7960()) {
            this.backpacked$Inventory = null;
            return null;
        }
        BackpackItem backpackItem = (BackpackItem)stack.method_7909();
        if (this.backpacked$Inventory == null || !this.backpacked$Inventory.getBackpackStack().equals(stack) || this.backpacked$Inventory.method_5439() != backpackItem.getRowCount() * backpackItem.getColumnCount()) {
            this.backpacked$Inventory = new BackpackInventory(backpackItem.getColumnCount(), backpackItem.getRowCount(), player, stack);
        }
        return this.backpacked$Inventory;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void backpacked$TickHead(CallbackInfo ci) {
        if (this.backpacked$Inventory != null) {
            this.backpacked$Inventory.tick();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void backpacked$AddAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        if (this.backpacked$Inventory != null) {
            this.backpacked$Inventory.saveItemsToStack();
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")})
    public void backpacked$InteractHead(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = (class_1657)this;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            BackpackedInteractAccess access = (BackpackedInteractAccess)serverPlayer;
            List<class_2960> capturedIds = access.getBackpacked$CapturedInteractIds();
            capturedIds.clear();
            class_1799 stack = serverPlayer.method_5998(hand);
            ((InteractedWithEntity.Capture)BackpackedEvents.INTERACTED_WITH_ENTITY_CAPTURE.post()).handle(serverPlayer, stack, entity, capturedIds::add);
        }
    }

    @Unique
    private void backpacked$PlayerTravelEvent(double dx, double dy, double dz, MovementType type) {
        class_1657 player = (class_1657)this;
        if (player.method_37908().method_8608()) {
            return;
        }
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        ((PlayerTravel)BackpackedEvents.PLAYER_TRAVEL.post()).handle((class_3222)player, distanceSquared, type);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=0)})
    private void backpacked$MovementSwim(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, dy, dz, MovementType.SWIM);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=1)})
    private void backpacked$MovementWalkUnderwater(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, dy, dz, MovementType.WALK_UNDERWATER);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=2)})
    private void backpacked$MovementWalkOnWater(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, 0.0, dz, MovementType.WALK_ON_WATER);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=3)})
    private void backpacked$MovementClimb(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(0.0, dy, 0.0, MovementType.CLIMB);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=4)})
    private void backpacked$MovementSprint(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, 0.0, dz, MovementType.SPRINT);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=5)})
    private void backpacked$MovementSneak(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, 0.0, dz, MovementType.SNEAK);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=6)})
    private void backpacked$MovementWalk(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, 0.0, dz, MovementType.WALK);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=7)})
    private void backpacked$MovementElytraFlying(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, dy, dz, MovementType.ELYTRA_FLY);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=8)})
    private void backpacked$MovementFlying(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(dx, 0.0, dz, MovementType.FLY);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V", ordinal=8)})
    private void backpacked$MovementFall(double dx, double dy, double dz, CallbackInfo ci) {
        this.backpacked$PlayerTravelEvent(0.0, dy, 0.0, MovementType.FALL);
    }
}

