/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.widget;

import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Objects;

public abstract class AbstractStatWidget<S extends SUStat<?>>
extends TClickableWidget {
    protected final S stat;
    protected int backgroundColor = 0x50000000;
    protected int outlineColor = 0;
    protected int focusOutlineColor = -5570561;

    public AbstractStatWidget(int x, int y, int width, int height, S stat) throws NullPointerException {
        super(x, y, width, height);
        this.stat = (SUStat)Objects.requireNonNull(stat);
    }

    public final S getStat() {
        return this.stat;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getOutlineColor() {
        return this.outlineColor;
    }

    public final int getFocusOutlineColor() {
        return this.focusOutlineColor;
    }

    @Virtual
    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Virtual
    public void setOutlineColor(int outlineColor) {
        this.outlineColor = outlineColor;
    }

    @Virtual
    public void setFocusOutlineColor(int focusOutlineColor) {
        this.focusOutlineColor = focusOutlineColor;
    }

    @Virtual
    protected void onClick() {
    }

    @Virtual
    public boolean input(TInputContext inputContext) {
        switch (inputContext.getInputType()) {
            case MOUSE_PRESS: {
                if (!this.isFocused()) break;
                this.getParentTScreen().setFocusedElement(null);
                return true;
            }
        }
        return super.input(inputContext);
    }

    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTFill(this.backgroundColor);
    }

    @Virtual
    public void postRender(TDrawContext pencil) {
        if (this.isFocusedOrHovered()) {
            pencil.drawTBorder(this.focusOutlineColor);
        } else {
            pencil.drawTBorder(this.outlineColor);
        }
    }
}

