/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.brewinandchewin.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.brewinandchewin.common.registry.BCRecipeTypes;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BCKegRecipeBuilder {
    private final List<class_1856> ingredients = Lists.newArrayList();
    private final class_1792 result;
    private final int count;
    private final int cookingTime;
    private final float experience;
    private final class_1792 container;
    private final class_1792 liquid;
    private final int temperature;

    private BCKegRecipeBuilder(class_1935 resultIn, int count, int cookingTime, float experience, @Nullable class_1935 container, @Nullable class_1935 liquid, int temperature) {
        this.result = resultIn.method_8389();
        this.count = count;
        this.liquid = liquid != null ? liquid.method_8389() : null;
        this.cookingTime = cookingTime;
        this.experience = experience;
        this.container = container != null ? container.method_8389() : null;
        this.temperature = temperature;
    }

    public static BCKegRecipeBuilder kegRecipe(class_1935 mainResult, int count, int cookingTime, float experience, class_1935 liquid, int temperature) {
        return new BCKegRecipeBuilder(mainResult, count, cookingTime, experience, null, liquid, temperature);
    }

    public static BCKegRecipeBuilder kegRecipe(class_1935 mainResult, int count, int cookingTime, float experience, int temperature) {
        return new BCKegRecipeBuilder(mainResult, count, cookingTime, experience, null, null, temperature);
    }

    public static BCKegRecipeBuilder kegRecipe(class_1935 mainResult, int count, int cookingTime, float experience, class_1935 container, class_1935 liquid, int temperature) {
        return new BCKegRecipeBuilder(mainResult, count, cookingTime, experience, container, liquid, temperature);
    }

    public BCKegRecipeBuilder addIngredient(class_6862<class_1792> tagIn) {
        return this.addIngredient(class_1856.method_8106(tagIn));
    }

    public BCKegRecipeBuilder addIngredient(class_1935 itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public BCKegRecipeBuilder addIngredient(class_1935 itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{itemIn}));
        }
        return this;
    }

    public BCKegRecipeBuilder addIngredient(class_1856 ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public BCKegRecipeBuilder addIngredient(class_1856 ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public void build(Consumer<class_2444> consumerIn) {
        class_2960 location = class_7923.field_41178.method_10221((Object)this.result);
        this.build(consumerIn, "brewinandchewin:fermenting/" + location.method_12832());
    }

    public void build(Consumer<class_2444> consumerIn, String save) {
        class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)this.result);
        if (new class_2960(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Fermenting Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new class_2960(save));
    }

    public void build(Consumer<class_2444> consumerIn, class_2960 id) {
        consumerIn.accept(new Result(id, this.result, this.count, this.ingredients, this.cookingTime, this.experience, this.container, this.liquid, this.temperature));
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final List<class_1856> ingredients;
        private final class_1792 result;
        private final int count;
        private final int cookingTime;
        private final float experience;
        private final class_1792 container;
        private final class_1792 liquid;
        private final int temperature;

        public Result(class_2960 idIn, class_1792 resultIn, int countIn, List<class_1856> ingredientsIn, int cookingTimeIn, float experienceIn, @Nullable class_1792 containerIn, @Nullable class_1792 liquidIn, int temperatureIn) {
            this.id = idIn;
            this.ingredients = ingredientsIn;
            this.result = resultIn;
            this.count = countIn;
            this.cookingTime = cookingTimeIn;
            this.experience = experienceIn;
            this.container = containerIn;
            this.liquid = liquidIn;
            this.temperature = temperatureIn;
        }

        public void method_10416(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                arrayIngredients.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", ((class_5321)class_7923.field_41178.method_29113((Object)this.result).get()).method_29177().toString());
            if (this.count > 1) {
                objectResult.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)objectResult);
            if (this.container != null) {
                JsonObject objectContainer = new JsonObject();
                objectContainer.addProperty("item", ((class_5321)class_7923.field_41178.method_29113((Object)this.container).get()).method_29177().toString());
                json.add("container", (JsonElement)objectContainer);
            }
            if (this.liquid != null) {
                JsonObject objectLiquid = new JsonObject();
                objectLiquid.addProperty("item", ((class_5321)class_7923.field_41178.method_29113((Object)this.liquid).get()).method_29177().toString());
                json.add("liquid", (JsonElement)objectLiquid);
            }
            if (this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            json.addProperty("cookingtime", (Number)this.cookingTime);
            json.addProperty("temperature", (Number)this.temperature);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return BCRecipeTypes.KEG_RECIPE_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

