/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.networking;

import commonnetwork.Constants;
import commonnetwork.networking.PacketRegistrationHandler;
import commonnetwork.networking.data.PacketContainer;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import commonnetwork.networking.exceptions.RegistrationException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, Message<?>> CHANNELS = new HashMap();

    public FabricNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.CHANNELS.get(container.messageType()) == null) {
            this.CHANNELS.put(container.messageType(), new Message<T>(container.packetIdentifier(), container.encoder()));
            if (Side.CLIENT.equals((Object)this.side)) {
                Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.packetIdentifier(), container.messageType(), Side.CLIENT});
                ClientPlayNetworking.registerGlobalReceiver((class_2960)container.packetIdentifier(), (client, listener, buf, responseSender) -> {
                    buf.readByte();
                    Object message = container.decoder().apply(buf);
                    client.execute(() -> container.handler().accept(new PacketContext<Object>(message, Side.CLIENT)));
                });
            }
            Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.packetIdentifier(), container.messageType(), Side.SERVER});
            ServerPlayNetworking.registerGlobalReceiver((class_2960)container.packetIdentifier(), (server, player, listener, buf, responseSender) -> {
                buf.readByte();
                Object message = container.decoder().apply(buf);
                server.execute(() -> container.handler().accept(new PacketContext<Object>(player, message, Side.SERVER)));
            });
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            if (ClientPlayNetworking.canSend((class_2960)message.id()) || ignoreCheck) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeByte(0);
                message.encoder().accept(packet, buf);
                ClientPlayNetworking.send((class_2960)message.id(), (class_2540)buf);
            }
        } else {
            throw new RegistrationException(packet.getClass() + "{} packet not registered on the client, packets need to be registered don both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, class_3222 player) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)message.id())) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeByte(0);
                message.encoder().accept(packet, buf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)message.id(), (class_2540)buf);
            }
        } else {
            throw new RegistrationException(packet.getClass() + "{} packet not registered on the server, packets need to be registered don both sides!");
        }
    }

    public record Message<T>(class_2960 id, BiConsumer<T, class_2540> encoder) {
    }
}

