/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc;

import com.mojang.brigadier.CommandDispatcher;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.commands.ModArgumentTypes;
import de.markusbordihn.easynpc.commands.manager.CommandManager;
import de.markusbordihn.easynpc.compat.CompatHandler;
import de.markusbordihn.easynpc.compat.CompatManager;
import de.markusbordihn.easynpc.config.Config;
import de.markusbordihn.easynpc.debug.DebugManager;
import de.markusbordihn.easynpc.entity.LivingEntityEventHandler;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.item.ModItems;
import de.markusbordihn.easynpc.menu.MenuHandler;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.server.ServerEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCMain
implements ModInitializer {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public void onInitialize() {
        log.info("Initializing {} (Fabric) ...", (Object)"Easy NPC");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC");
        if (System.getProperty("fabric.development") != null) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Constants.GAME_DIR = FabricLoader.getInstance().getGameDir();
        Constants.CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
        log.info("{} Configuration ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Config.register(FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER);
        log.info("{} Common Data Files ...", (Object)"\ud83d\udde3 Register Easy NPC");
        DataFileHandler.registerCommonDataFiles();
        log.info("{} Entity Data Serializers ...", (Object)"\ud83d\udde3 Register Easy NPC");
        EntityDataSerializersManager.register();
        log.info("{} Compatibility Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        CompatManager.registerCompatHandler(new CompatHandler());
        log.info("{} Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModEntityType.registerEntitiesAttributes();
        log.info("{} Blocks ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.registerModBlocks();
        log.info("{} Blocks Entities ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.registerModBlockEntities();
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModItems.registerModItems();
        log.info("{} Command register event ...", (Object)"\ud83d\udde3 Register Easy NPC");
        CommandRegistrationCallback.EVENT.register((dispatcher, commandBuildContext, commandSelection) -> CommandManager.registerCommands((CommandDispatcher<class_2168>)dispatcher, commandBuildContext));
        log.info("{} Server Events ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ServerLifecycleEvents.SERVER_STARTING.register(ServerEvents::handleServerStarting);
        ServerTickEvents.END_SERVER_TICK.register(ServerEvents::handleServerTick);
        LivingEntityEventHandler.registerServerEntityEvents();
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        MenuManager.registerMenuHandler(new MenuHandler());
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModMenuTypes.register();
        log.info("{} Server Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        NetworkHandlerManager.registerHandler(new NetworkHandler());
        NetworkHandlerManager.registerNetworkMessages(NetworkHandlerManagerType.SERVER);
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
        log.info("{} Argument Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModArgumentTypes.register();
    }
}

