/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseEntityModel;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class StandardHorseModel<T extends class_1297>
extends BaseEntityModel<T>
implements class_3882 {
    protected final class_630 head;
    protected final class_630 body;
    protected final class_630 rightFrontLeg;
    protected final class_630 leftFrontLeg;
    protected final class_630 rightHindLeg;
    protected final class_630 leftHindLeg;
    protected final class_630 tail;
    protected final class_630 headParts;
    protected final class_630 saddle;
    protected final class_630 leftSaddleMouth;
    protected final class_630 rightSaddleMouth;
    protected final class_630 leftSaddleLine;
    protected final class_630 rightSaddleLine;
    protected final class_630 headSaddle;
    protected final class_630 mouthSaddleWrap;

    public StandardHorseModel(class_630 modelPart) {
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.headParts = this.defineModelPart(ModelPartType.HEAD_PARTS, modelPart, "head_parts");
        this.head = this.defineModelPart(ModelPartType.HEAD, this.headParts, "head");
        this.rightFrontLeg = this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.leftFrontLeg = this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.rightHindLeg = this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.leftHindLeg = this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.tail = this.defineModelPart(ModelPartType.TAIL, this.body, "tail");
        this.saddle = this.body.method_32086("saddle");
        this.rightSaddleMouth = this.headParts.method_32086("right_saddle_mouth");
        this.leftSaddleMouth = this.headParts.method_32086("left_saddle_mouth");
        this.rightSaddleLine = this.headParts.method_32086("right_saddle_line");
        this.leftSaddleLine = this.headParts.method_32086("left_saddle_line");
        this.headSaddle = this.headParts.method_32086("head_saddle");
        this.mouthSaddleWrap = this.headParts.method_32086("mouth_saddle_wrap");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD_PARTS, this.headParts);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.TAIL, this.tail);
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        boolean isSaddled;
        VariantData<?> variantData = easyNPC.getEasyNPCVariantData();
        this.saddle.field_3665 = isSaddled = variantData.hasVariantSaddled();
        this.rightSaddleMouth.field_3665 = isSaddled;
        this.leftSaddleMouth.field_3665 = isSaddled;
        this.rightSaddleLine.field_3665 = isSaddled;
        this.leftSaddleLine.field_3665 = isSaddled;
        this.headSaddle.field_3665 = isSaddled;
        this.mouthSaddleWrap.field_3665 = isSaddled;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.headParts, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelFrontLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean animateModelHindLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightLegPart, class_630 leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    public Iterable<class_630> headParts() {
        return List.of(this.headParts);
    }

    protected Iterable<class_630> bodyParts() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg);
    }

    @Override
    public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.headParts().forEach(headPart -> headPart.method_22699(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha));
        this.bodyParts().forEach(bodyPart -> bodyPart.method_22699(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha));
    }

    public class_630 method_2838() {
        return this.head;
    }

    @Override
    public boolean isHumanoidModel() {
        return false;
    }
}

