/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmPoseAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_606;
import net.minecraft.class_630;

public class StandardSkeletonModel<T extends class_1308>
extends class_606<T>
implements EasyNPCModel<T>,
HumanoidArmAnimation,
HumanoidArmPoseAnimation {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);

    public StandardSkeletonModel(class_630 modelPart) {
        super(modelPart);
        this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.defineModelPart(ModelPartType.HAT, modelPart, "hat");
        this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm");
        this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm");
        this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.field_3398);
        this.resetModelPart(ModelPartType.HAT, this.field_3394);
        this.resetModelPart(ModelPartType.BODY, this.field_3391);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.field_3401);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.field_27433);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.field_3392);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.field_3397);
    }

    public void method_19690(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((class_1297)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.method_19690(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.field_3654 = headPitch * ((float)Math.PI / 180);
        headPart.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean animateModelArms(T entity, AttackData<?> attackData, ModelData<?> modelData, class_630 rightArmPart, class_630 leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean animateModelArmPose(T entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidArmPoseAnimation.animateHumanoidArmPose(entity, modelArmPose, this.field_3398, this.field_3391, this.field_3401, this.field_27433, this.field_3447, ageInTicks);
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        this.field_3394.method_17138(this.field_3398);
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.field_3398, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.field_3391, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.field_27433, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.field_3401, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.field_3397, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.field_3392, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.field_3391.field_3654 = 0.5f;
        this.field_3391.field_3656 = 3.2f;
        this.field_3398.field_3656 = 4.2f;
        this.field_27433.field_3654 += 0.4f;
        this.field_27433.field_3656 = 5.2f;
        this.field_3397.field_3656 = 12.2f;
        this.field_3397.field_3655 = 4.0f;
        this.field_3401.field_3654 += 0.4f;
        this.field_3401.field_3656 = 5.2f;
        this.field_3392.field_3656 = 12.2f;
        this.field_3392.field_3655 = 4.0f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, class_630> getModelPartMap() {
        return this.modelPartMap;
    }
}

