/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.pose;

import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PoseManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String TEXTURE_PREFIX = "pose/";
    private static final String LOG_PREFIX = "[Pose Manager]";
    private static final Map<class_2960, AnimationData.Animation> poseDataMap = new HashMap<class_2960, AnimationData.Animation>();

    private PoseManager() {
    }

    public static void registerPoseData(SkinModel skinModel, AnimationData animationData) {
        if (skinModel == null || animationData == null) {
            log.error("{} Pose data {} is invalid!", (Object)LOG_PREFIX, (Object)skinModel);
            return;
        }
        for (AnimationData.Animation animation : animationData.getAnimations().values()) {
            if (animation.getBones() == null || animation.getBones().isEmpty()) {
                log.warn("{} pose data {} with name {} has no bones!", (Object)LOG_PREFIX, (Object)skinModel, (Object)animation.getName());
                continue;
            }
            PoseManager.registerPoseData(PoseManager.getResourceLocation(skinModel, animation), animation);
        }
    }

    public static class_2960 getResourceLocation(SkinModel skinModel, AnimationData.Animation animation) {
        try {
            String resourcePath = TEXTURE_PREFIX + skinModel.name().toLowerCase(Locale.ROOT) + "/" + animation.getName().replaceAll("[^a-zA-Z0-9_.-]", "").toLowerCase(Locale.ROOT);
            return new class_2960("easy_npc", resourcePath);
        }
        catch (Exception exception) {
            log.error("{} Could not create resource location for {} with {}", (Object)LOG_PREFIX, (Object)skinModel, (Object)animation, (Object)exception);
            return null;
        }
    }

    public static AnimationData.Animation getPoseData(class_2960 resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        return poseDataMap.get(resourceLocation);
    }

    public static Set<class_2960> getPoseDataKeys() {
        return poseDataMap.keySet();
    }

    private static void registerPoseData(class_2960 resourceLocation, AnimationData.Animation animation) {
        if (resourceLocation == null || animation == null) {
            log.error("{} Pose data {} is invalid!", (Object)LOG_PREFIX, (Object)resourceLocation);
            return;
        }
        if (poseDataMap.containsKey(resourceLocation)) {
            log.warn("{} Pose data {} already registered!", (Object)LOG_PREFIX, (Object)resourceLocation);
        }
        log.info("{} Registering pose data {} with {}", (Object)LOG_PREFIX, (Object)resourceLocation, (Object)animation);
        poseDataMap.put(resourceLocation, animation);
    }

    public static void resetModelPose(EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("{} Model data is missing for Easy NPC {}!", (Object)LOG_PREFIX, (Object)easyNPC.getUUID());
            return;
        }
        easyNPC.getEntity().method_18380(class_4050.field_18076);
        modelData.setModelPose(ModelPose.DEFAULT);
    }

    public static boolean setModelPose(EasyNPC<?> easyNPC, AnimationData.Animation animation) {
        if (easyNPC == null || animation == null) {
            return false;
        }
        if (animation.getBones() == null || animation.getBones().isEmpty()) {
            log.error("{} Animation data is missing for {}!", (Object)LOG_PREFIX, (Object)animation.getName());
            return false;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("{} Model data is missing for Easy NPC {}!", (Object)LOG_PREFIX, (Object)easyNPC.getUUID());
            return false;
        }
        easyNPC.getEntity().method_18380(class_4050.field_18076);
        modelData.setModelPose(ModelPose.CUSTOM);
        for (String boneName : animation.getBones().keySet()) {
            AnimationData.Bone bone = animation.getBones().get(boneName);
            ModelPart modelPart = ModelPart.get(boneName);
            if (modelPart == ModelPart.UNKNOWN) {
                log.error("{} Bone {} is not supported!", (Object)LOG_PREFIX, (Object)boneName);
                continue;
            }
            List<Float> position = bone.getPosition();
            CustomPosition customPosition = position == null ? new CustomPosition(0.0f, 0.0f, 0.0f) : new CustomPosition(position.get(0).floatValue(), position.get(1).floatValue() * -1.0f, position.get(2).floatValue());
            List<Float> rotation = bone.getRotation();
            CustomRotation customRotation = rotation == null ? new CustomRotation(0.0f, 0.0f, 0.0f) : new CustomRotation(rotation.get(0).floatValue() * (float)Math.PI / 180.0f, rotation.get(1).floatValue() * (float)Math.PI / 180.0f, rotation.get(2).floatValue() * (float)Math.PI / 180.0f);
            modelData.setModelPartPosition(modelPart, customPosition);
            modelData.setModelPartRotation(modelPart, customRotation);
            log.debug("{} Set {} to {} / {}", (Object)LOG_PREFIX, (Object)modelPart, (Object)customPosition, (Object)customRotation);
        }
        return true;
    }
}

