/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.raw.ZombieRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1642;
import net.minecraft.class_2960;
import net.minecraft.class_3886;
import net.minecraft.class_5617;

public class ZombieRawRenderer
extends class_3886 {
    protected static final Map<ZombieRaw.Variant, class_2960> TEXTURE_BY_VARIANT = (Map)class_156.method_654(new EnumMap(ZombieRaw.Variant.class), map -> {
        map.put(ZombieRaw.Variant.DROWNED, new class_2960("textures/entity/zombie/drowned.png"));
        map.put(ZombieRaw.Variant.HUSK, new class_2960("textures/entity/zombie/husk.png"));
        map.put(ZombieRaw.Variant.ZOMBIE, new class_2960("textures/entity/zombie/zombie.png"));
    });
    protected static final class_2960 DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)ZombieRaw.Variant.ZOMBIE);

    public ZombieRawRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public class_2960 method_4163(class_1642 zombie) {
        if (zombie instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)zombie;
            return this.getEntityTexture(easyNPC);
        }
        return super.method_4163(zombie);
    }

    public class_2960 getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public class_2960 getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public class_2960 getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public class_2960 getTextureByVariant(Enum<?> variant) {
        return TEXTURE_BY_VARIANT != null ? TEXTURE_BY_VARIANT.getOrDefault(variant, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public <N extends EasyNPC<?>> class_2960 getEntityTexture(N easyNPC) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

