/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.manager;

import de.markusbordihn.easynpc.compat.CompatConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_310;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Renderer Manager]";
    private static final Map<class_1299<? extends class_1297>, class_897<? extends class_1297>> entityRendererMap = new HashMap<class_1299<? extends class_1297>, class_897<? extends class_1297>>();
    private static final Map<class_1299<? extends class_1297>, class_922<? extends class_1309, ? extends class_583<? extends class_1309>>> livingEntityRendererMap = new HashMap<class_1299<? extends class_1297>, class_922<? extends class_1309, ? extends class_583<? extends class_1309>>>();

    private RendererManager() {
    }

    public static class_922<? extends class_1309, ? extends class_583<? extends class_1309>> getLivingEntityRenderer(class_1299<? extends class_1297> entityType, class_1314 pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        class_922<? extends class_1309, ? extends class_583<? extends class_1309>> livingEntityRenderer = livingEntityRendererMap.get(entityType);
        if (livingEntityRenderer != null) {
            return livingEntityRenderer;
        }
        RendererManager.registerLivingEntityRenderer(entityType, pathfinderMob);
        return livingEntityRendererMap.get(entityType);
    }

    public static class_897<? extends class_1297> getEntityRenderer(class_1299<?> entityType, class_1314 pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        class_897<? extends class_1297> entityRenderer = entityRendererMap.get(entityType);
        if (entityRenderer != null) {
            return entityRenderer;
        }
        RendererManager.registerEntityRenderer(entityType, pathfinderMob);
        return entityRendererMap.get(entityType);
    }

    public static class_922<? extends class_1309, ? extends class_583<? extends class_1309>> registerLivingEntityRenderer(class_1299<? extends class_1297> entityType, class_1314 pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (livingEntityRendererMap.containsKey(entityType)) {
            return livingEntityRendererMap.get(entityType);
        }
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953((class_1297)pathfinderMob);
        if (entityRenderer instanceof class_922) {
            class_922 livingEntityRenderer = (class_922)entityRenderer;
            log.debug("{} Registering living entity renderer {} for {}", (Object)LOG_PREFIX, (Object)livingEntityRenderer, entityType);
            livingEntityRendererMap.put(entityType, (class_922<? extends class_1309, ? extends class_583<? extends class_1309>>)livingEntityRenderer);
            return livingEntityRenderer;
        }
        if (!entityRendererMap.containsKey(entityType)) {
            log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
            entityRendererMap.put(entityType, (class_897<? extends class_1297>)entityRenderer);
        }
        return null;
    }

    public static class_897<? extends class_1297> registerEntityRenderer(class_1299<? extends class_1297> entityType, class_1314 pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (entityRendererMap.containsKey(entityType)) {
            return entityRendererMap.get(entityType);
        }
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953((class_1297)pathfinderMob);
        log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
        entityRendererMap.put(entityType, (class_897<? extends class_1297>)entityRenderer);
        return entityRenderer;
    }

    public static void copyModSpecificData(class_1314 sourceEntity, class_1297 targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        if (!CompatConstants.MOD_COBBLEMON_LOADED || entityTypeName.equals("cobblemon:pokemon")) {
            // empty if block
        }
    }

    public static void copyCustomEntityData(class_1314 sourceEntity, class_1297 targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyModSpecificData(sourceEntity, targetEntity, entityTypeName);
        targetEntity.field_6012 = sourceEntity.field_6012;
        targetEntity.method_36456(sourceEntity.method_36454());
        targetEntity.field_5982 = sourceEntity.field_5982;
        targetEntity.method_36457(sourceEntity.method_36455());
        targetEntity.field_6004 = sourceEntity.field_6004;
        targetEntity.method_5847(sourceEntity.method_5791());
        targetEntity.method_5636(sourceEntity.field_6283);
        targetEntity.method_5814(sourceEntity.method_23317(), sourceEntity.method_23318(), sourceEntity.method_23321());
        targetEntity.method_24830(sourceEntity.method_24828());
        targetEntity.method_18799(sourceEntity.method_18798());
        if (sourceEntity.method_16914()) {
            targetEntity.method_5665(sourceEntity.method_5797());
            targetEntity.method_5880(sourceEntity.method_5807());
        }
        if (sourceEntity.method_18376() != targetEntity.method_18376()) {
            targetEntity.method_18380(sourceEntity.method_18376());
        }
    }

    public static void copyCustomLivingEntityData(class_1314 sourceEntity, class_1309 targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyCustomEntityData(sourceEntity, (class_1297)targetEntity, entityTypeName);
        targetEntity.field_6259 = sourceEntity.field_6259;
        targetEntity.field_6220 = sourceEntity.field_6220;
        targetEntity.field_6251 = sourceEntity.field_6251;
        targetEntity.field_6229 = sourceEntity.field_6229;
        if (!sourceEntity.method_6047().method_7960()) {
            targetEntity.method_6122(class_1268.field_5808, sourceEntity.method_6047());
        }
        if (!sourceEntity.method_6079().method_7960()) {
            targetEntity.method_6122(class_1268.field_5810, sourceEntity.method_6079());
        }
    }
}

