/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration;

import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ConfigurationScreen<T extends EasyNPCMenu>
extends Screen<T> {
    protected class_4185 homeButton = null;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;
    protected int numberOfDescriptionTextLines = 1;
    protected List<class_5481> descriptionTextComponents = Collections.emptyList();

    public ConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component, 328, 243);
        this.showCloseButton = false;
    }

    protected void renderDescriptionText(class_332 guiGraphics, int descriptionLeft, int descriptionTop) {
        if (!this.descriptionTextComponents.isEmpty() && this.numberOfDescriptionTextLines > 0) {
            for (int line = 0; line < this.numberOfDescriptionTextLines; ++line) {
                class_5481 formattedCharSequence = this.descriptionTextComponents.get(line);
                Objects.requireNonNull(this.field_22793);
                Text.drawString(guiGraphics, this.field_22793, formattedCharSequence, descriptionLeft, descriptionTop + line * (9 + 2));
            }
        }
    }

    protected void setDescriptionText(String textId) {
        this.setDescriptionText((class_2561)TextComponent.getTranslatedConfigText(textId));
    }

    protected void setDescriptionText(class_2561 component) {
        this.descriptionTextComponents = this.field_22793.method_1728((class_5348)component, this.imageWidth - 20);
        this.numberOfDescriptionTextLines = this.descriptionTextComponents.size();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.buttonLeftPos = this.leftPos + 13;
        this.buttonTopPos = this.topPos + 3;
        this.contentLeftPos = this.leftPos + 7;
        this.contentTopPos = this.topPos + 23;
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 3, this.buttonTopPos, 10, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN)));
    }

    @Override
    protected void renderLabels(class_332 guiGraphics, int x, int y) {
        if (!this.compactMode) {
            Text.drawString(guiGraphics, this.field_22793, this.field_22785, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040);
        }
    }

    public void showMainScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
    }

    @Override
    public boolean method_25404(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 && ConfigurationScreen.method_25443()) {
            this.showMainScreen();
            return true;
        }
        return super.method_25404(keyCode, unused1, unused2);
    }
}

