/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.validator.ImageValidator;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class UrlSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    protected class_4185 addTextureSettingsButton = null;
    protected class_342 textureSkinLocationBox;
    private boolean canTextureSkinLocationChange = true;
    private class_4185 clearTextureSettingsButton = null;
    private String formerTextureSkinLocation = "";
    private String errorMessage = "";

    public UrlSkinConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderSkins(class_332 guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set<UUID> textures = RemoteTextureManager.getTextureCacheKeys(skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(left, top, skinModel, textureKey);
            int topNamePos = Math.round((float)(top - 76) / 0.7f);
            int leftNamePos = Math.round((float)(left - 21) / 0.7f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            guiGraphics.method_51448().method_22905(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(guiGraphics, this.field_22793, variantName, leftNamePos, topNamePos, 43520);
            guiGraphics.method_51448().method_22909();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = RemoteTextureManager.getTextureSkinType(textureModelKey);
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            String skinURL = RemoteTextureManager.getTextureSkinURL(textureModelKey);
            NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), "", skinURL, textureUUID, skinType, "");
        });
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.field_22763 = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityCustomSkin(x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), textureUUID, skinType);
        this.skinButtons.add(skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.method_1882().isEmpty()) {
            this.textureSkinLocationBox.method_1852("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.method_1882();
        if (!textureSkinLocationValue.isEmpty() && !textureSkinLocationValue.equals(this.formerTextureSkinLocation)) {
            URL textureSkinLocation;
            if (!UrlValidator.isValidUrl(textureSkinLocationValue)) {
                this.errorMessage = "invalid_remote_image";
                return;
            }
            try {
                textureSkinLocation = new URL(textureSkinLocationValue);
            }
            catch (Exception e) {
                return;
            }
            if (!ImageValidator.isValidImage(textureSkinLocation)) {
                log.error("Unable to set remote user texture to {}", (Object)textureSkinLocationValue);
                this.errorMessage = "invalid_remote_image";
                return;
            }
            log.debug("Setting remote user texture to {}", (Object)textureSkinLocationValue);
            TextureManager.clearLastErrorMessage();
            this.errorMessage = "";
            NetworkMessageHandlerManager.getServerHandler().setRemoteSkin(this.getEasyNPCUUID(), textureSkinLocationValue);
            this.addTextureSettingsButton.field_22763 = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            UrlSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.method_1882();
        if (!this.canTextureSkinLocationChange) {
            this.addTextureSettingsButton.field_22763 = false;
            this.clearTextureSettingsButton.field_22763 = true;
            return;
        }
        this.addTextureSettingsButton.field_22763 = !textureSkinLocationValue.isEmpty() && UrlValidator.isValidUrl(textureSkinLocationValue);
        this.clearTextureSettingsButton.field_22763 = !textureSkinLocationValue.isEmpty();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.urlSkinButton.field_22763 = false;
        this.setDescriptionText("url_skin.text");
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = RemoteTextureManager.getTextureCacheKeys(skinModel).size();
        this.textureSkinLocationBox = new TextField(this.field_22793, this.contentLeftPos, this.contentTopPos + 50, 180);
        this.textureSkinLocationBox.method_1880(255);
        this.textureSkinLocationBox.method_1852("");
        this.textureSkinLocationBox.method_1863(consumer -> this.validateTextureSkinLocation());
        this.method_37063((class_364)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (class_4185)this.method_37063((class_364)new TextButton(this.textureSkinLocationBox.method_46426() + this.textureSkinLocationBox.method_25368() + 2, this.contentTopPos + 50, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.field_22763 = false;
        this.clearTextureSettingsButton = (class_4185)this.method_37063((class_364)new TextButton(this.addTextureSettingsButton.method_46426() + this.addTextureSettingsButton.method_25368() + 1, this.contentTopPos + 50, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        this.clearTextureSettingsButton.field_22763 = false;
        this.defineSkinNavigationButtons();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.addTextureSettingsButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "use_a_skin_url", this.contentLeftPos, this.addTextureSettingsButton.method_46427() - 10);
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            Graphics.blit(guiGraphics, Constants.TEXTURE_CONFIGURATION, this.leftPos + 176, this.contentTopPos + 53, 82, 1, 8, 10);
            if (!TextureManager.hasLastErrorMessage() && this.errorMessage.isEmpty()) {
                Text.drawConfigString(guiGraphics, this.field_22793, "processing_url_skin", this.leftPos + 55, this.contentTopPos + 80);
            }
        }
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            Text.drawErrorMessage(guiGraphics, this.field_22793, (class_2561)TextComponent.getTranslatedText(this.errorMessage), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        } else if (TextureManager.hasLastErrorMessage()) {
            Text.drawErrorMessage(guiGraphics, this.field_22793, TextureManager.getLastErrorMessage(), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        }
        this.renderSkins(guiGraphics);
    }
}

