/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class DialogEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_BUTTONS = 6;
    protected class_4185 homeButton;
    protected class_4185 dialogButton;
    protected class_4185 dialogTextButton;
    protected class_4185 addDialogButton;
    protected class_4185 saveButton;
    protected class_4185 cancelButton;
    protected class_4185 deleteButton;
    protected TextField dialogLabelTextField;
    protected Checkbox dialogLabelCheckbox;
    protected class_4185 dialogNameToLabelButton;
    protected class_4185 makeDefaultDialogButton;
    protected TextField dialogNameTextField;
    private String dialogLabelValue = "";
    private String dialogNameValue = "";

    public DialogEditorScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private void refreshScreen() {
        NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    private void openPreviousScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
    }

    private void deleteDialog() {
        class_310 minecraft = this.field_22787;
        if (minecraft == null) {
            return;
        }
        minecraft.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialog(this.getEasyNPCUUID(), this.getDialogUUID());
                NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
            } else {
                minecraft.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedText("removeDialog.deleteQuestion"), (class_2561)TextComponent.getTranslatedText("removeDialog.deleteWarning", this.getDialogData().getName()), (class_2561)TextComponent.getTranslatedText("removeDialog.deleteButton"), class_5244.field_24335));
    }

    private void renderEditLabels(class_332 guiGraphics) {
        if (this.dialogNameTextField != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "dialog.name", this.leftPos + 10, this.dialogNameTextField.method_46427() + 4, 0);
        }
        if (this.dialogLabelTextField != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "label_id", this.leftPos + 10, this.dialogLabelTextField.method_46427() + 4, 0);
        }
        if (this.dialogTextButton != null) {
            Text.drawConfigString(guiGraphics, this.field_22793, "dialog.text", this.leftPos + 10, this.dialogTextButton.method_46427() - 13, 0);
            Text.drawConfigString(guiGraphics, this.field_22793, "dialog.buttons", this.leftPos + 10, this.dialogTextButton.method_46427() + 27, 0);
        }
    }

    private void makeDefaultDialog() {
        if (this.getDialogUUID().equals(this.getDialogDataSet().getDefaultDialogId())) {
            return;
        }
        DialogDataSet dialogDataSet = this.getDialogDataSet();
        dialogDataSet.setDefaultDialog(this.getDialogUUID());
        NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
    }

    private void saveDialogData() {
        boolean hasChanged;
        boolean bl = hasChanged = !this.dialogNameTextField.method_1882().equals(this.dialogNameValue) || !this.dialogLabelTextField.method_1882().equals(this.dialogLabelValue);
        if (!hasChanged) {
            return;
        }
        DialogDataEntry dialogDataEntry = this.getDialogData();
        dialogDataEntry.setName(this.dialogNameTextField.method_1882());
        dialogDataEntry.setLabel(this.dialogLabelTextField.method_1882());
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.saveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.deleteButton = (class_4185)this.method_37063((class_364)new DeleteButton(this.saveButton.method_46426() + this.saveButton.method_25368() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialog()));
        this.cancelButton = (class_4185)this.method_37063((class_364)new CancelButton(this.deleteButton.method_46426() + this.deleteButton.method_25368() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
        DialogDataEntry dialogDataEntry = this.getDialogData();
        this.dialogButton = (class_4185)this.method_37063((class_364)new DialogButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 7, 140, dialogDataEntry.getName(21), onPress -> {}));
        this.dialogButton.field_22763 = false;
        this.dialogNameValue = this.getDialogData().getName();
        this.dialogNameTextField = new TextField(this.field_22793, this.leftPos + 100, this.topPos + 30, 150, this.dialogNameValue);
        this.dialogNameTextField.method_1880(64);
        this.method_37063((class_364)this.dialogNameTextField);
        this.dialogNameToLabelButton = (class_4185)this.method_37063((class_364)new SpriteButton(this.dialogNameTextField.method_46426() + this.dialogNameTextField.method_25368() + 1, this.dialogNameTextField.method_46427() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.dialogNameTextField != null && this.dialogLabelTextField != null) {
                String buttonName = this.dialogNameTextField.method_1882();
                this.dialogLabelTextField.method_1852(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.makeDefaultDialogButton = (class_4185)this.method_37063((class_364)new SpriteButton(this.dialogNameToLabelButton.method_46426() + this.dialogNameToLabelButton.method_25368() + 1, this.dialogNameToLabelButton.method_46427(), 30, 18, 2, 2, 92, 128, 25, 12, onPress -> {
            this.makeDefaultDialog();
            this.refreshScreen();
        }));
        this.dialogLabelValue = dialogDataEntry.getLabel();
        this.dialogLabelTextField = new TextField(this.field_22793, this.leftPos + 100, this.topPos + 50, 100);
        this.dialogLabelTextField.method_1880(32);
        this.dialogLabelTextField.method_1852(this.dialogLabelValue);
        this.dialogLabelTextField.method_1888(this.dialogLabelTextField.method_1882().isEmpty());
        this.method_37063((class_364)this.dialogLabelTextField);
        this.dialogLabelCheckbox = new Checkbox(this.leftPos + 203, this.dialogLabelTextField.method_46427() + 1, "locked", !dialogDataEntry.getLabel().isEmpty(), checkbox -> this.dialogLabelTextField.method_1888(!checkbox.selected()));
        this.method_37063((class_364)this.dialogLabelCheckbox);
        this.dialogTextButton = (class_4185)this.method_37063((class_364)new TextEditButton(this.leftPos + 7, this.topPos + 105, 303, "dialog.edit_text", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.defineDialogButtons(dialogDataEntry);
    }

    private void defineDialogButtons(DialogDataEntry dialogDataEntry) {
        Set<DialogButtonEntry> dialogButtons = dialogDataEntry.getDialogButtons();
        boolean smallButtons = dialogButtons.size() < 4;
        int buttonIndex = 0;
        int buttonBaseLeftPos = this.leftPos + 7;
        int buttonTopPos = this.topPos + 145;
        int buttonLeftPos = buttonBaseLeftPos;
        int buttonSpace = 3;
        int buttonWidth = smallButtons ? 150 : 100;
        int buttonMaxTextLength = smallButtons ? 22 : 14;
        for (DialogButtonEntry dialogButtonEntry : dialogButtons) {
            if (buttonIndex > 5) break;
            if (smallButtons && buttonIndex == 2 || !smallButtons && buttonIndex == 3) {
                buttonTopPos += 20;
                buttonLeftPos = buttonBaseLeftPos;
            }
            DialogButtonButton dialogActionButton = new DialogButtonButton(buttonLeftPos, buttonTopPos, buttonWidth, dialogButtonEntry.getButtonName(buttonMaxTextLength).getString(), onPress -> {
                log.info("Edit dialog button {}", (Object)dialogButtonEntry.id());
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), dialogButtonEntry.id());
            });
            this.method_37063((class_364)dialogActionButton);
            buttonLeftPos += buttonWidth + buttonSpace;
            ++buttonIndex;
        }
        if (buttonIndex < 6) {
            this.addDialogButton = new AddButton(dialogButtons.size() < 5 && buttonIndex != 2 ? buttonLeftPos : buttonBaseLeftPos, dialogButtons.size() < 5 && buttonIndex != 2 ? buttonTopPos : buttonTopPos + 20, smallButtons ? buttonWidth : 150, "dialog.add_button", onPress -> {
                this.saveDialogData();
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            });
            this.method_37063((class_364)this.addDialogButton);
        }
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.field_22763 = !this.dialogNameTextField.method_1882().equals(this.dialogNameValue) || !this.dialogLabelTextField.method_1882().equals(this.dialogLabelValue);
        }
        if (this.dialogLabelCheckbox != null && this.dialogNameToLabelButton != null) {
            boolean bl = this.dialogNameToLabelButton.field_22763 = !this.dialogLabelCheckbox.selected();
        }
        if (this.makeDefaultDialogButton != null && this.getDialogDataSet() != null) {
            this.makeDefaultDialogButton.field_22763 = !this.getDialogUUID().equals(this.getDialogDataSet().getDefaultDialogId());
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.dialogNameToLabelButton != null && this.dialogNameToLabelButton.method_25405((double)x, (double)y)) {
            guiGraphics.method_51438(this.field_22793, (class_2561)TextComponent.getTranslatedConfigText("name_to_label.tooltip"), x, y);
        }
        if (this.makeDefaultDialogButton != null && this.makeDefaultDialogButton.method_25405((double)x, (double)y)) {
            guiGraphics.method_51438(this.field_22793, (class_2561)TextComponent.getTranslatedConfigText("make_default.tooltip"), x, y);
        }
    }
}

