/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final int RELOAD_PROTECTION = 10000;
    private static final HashMap<TextureModelKey, class_2960> textureCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static final String LOG_PREFIX = "[Custom Texture Manager] ";
    private static int reloadProtectionCounter = 0;

    private CustomTextureManager() {
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel) {
        return CustomTextureManager.getCustomTextureCacheKeys(skinModel, null);
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel, String searchName) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        String skinSearchName = searchName != null && !searchName.isEmpty() ? searchName.toLowerCase(Locale.ROOT) : null;
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || skinSearchName != null && !textureModelKey.getResourceName().isEmpty() && !textureModelKey.getResourceName().toLowerCase(Locale.ROOT).contains(skinSearchName)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static class_2960 getOrCreateTextureWithDefault(SkinData<?> skinData, class_2960 defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        class_2960 resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            return resourceLocation;
        }
        class_2960 createdResourceLocation = CustomTextureManager.createTexture(textureModelKey, skinData);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static class_2960 createTexture(TextureModelKey textureModelKey, SkinData<?> skinData) {
        UUID skinUUID = textureModelKey.getUUID();
        if (!textureReloadProtection.add(skinUUID)) {
            if (reloadProtectionCounter++ > 10000) {
                textureReloadProtection.clear();
                reloadProtectionCounter = 0;
            }
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        class_2960 localTextureCache = TextureManager.searchCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            return localTextureCache;
        }
        log.error("{} Unable to load custom texture {} {} from {}", (Object)LOG_PREFIX, (Object)skinModel, (Object)skinUUID, (Object)textureDataFolder);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_43496((class_2561)TextComponent.getText("[Custom Texture Manager] Unable to load custom texture " + textureModelKey + " from: " + textureDataFolder).method_27692(class_124.field_1061));
        }
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        CustomTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        class_2960 resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }

    public static void clearTextureCache() {
        textureReloadProtection.clear();
        textureCache.clear();
    }
}

