/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ReflectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogArgument
implements ArgumentType<Pair<UUID, String>> {
    public static final SimpleCommandExceptionType ERROR_INVALID_UUID = new SimpleCommandExceptionType((Message)TextComponent.getTranslatedTextRaw("argument.uuid.invalid"));
    private static final Collection<String> EXAMPLES = List.of("dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final Pattern ALLOWED_CHARACTERS_UUID = Pattern.compile("^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$");
    private static final Pattern ALLOWED_CHARACTERS_ID = Pattern.compile("^(\\w+)");
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private Map<String, DialogDataEntry> dialogDataEntriesCache = new HashMap<String, DialogDataEntry>();

    public static DialogArgument uuidOrLabel() {
        return new DialogArgument();
    }

    public static Pair<UUID, String> getUuidOrLabel(CommandContext<class_2168> commandContext, String dialog) {
        return (Pair)commandContext.getArgument(dialog, Pair.class);
    }

    public Pair<UUID, String> parse(StringReader stringReader) throws CommandSyntaxException {
        String input = stringReader.getRemaining();
        Matcher uuidMatcher = ALLOWED_CHARACTERS_UUID.matcher(input);
        Matcher idMatcher = ALLOWED_CHARACTERS_ID.matcher(input);
        if (uuidMatcher.find()) {
            String uuidString = uuidMatcher.group(1);
            try {
                UUID uuid = UUID.fromString(uuidString);
                stringReader.setCursor(stringReader.getCursor() + uuidString.length());
                return new Pair((Object)uuid, (Object)"");
            }
            catch (IllegalArgumentException exception) {
                log.error("Found invalid dialog uuid {}", (Object)uuidString);
            }
        }
        if (idMatcher.find()) {
            String idString = idMatcher.group(1);
            if (this.dialogDataEntriesCache != null && !this.dialogDataEntriesCache.isEmpty() && this.dialogDataEntriesCache.containsKey(idString)) {
                DialogDataEntry dialogDataEntry = this.dialogDataEntriesCache.get(idString);
                log.debug("Found dialog id {}: {}", (Object)idString, (Object)dialogDataEntry);
                UUID uuid = dialogDataEntry.getId();
                stringReader.setCursor(stringReader.getCursor() + uuid.toString().length());
                return new Pair((Object)uuid, (Object)idString);
            }
            stringReader.setCursor(stringReader.getCursor() + idString.length());
            return new Pair(null, (Object)idString);
        }
        throw ERROR_INVALID_UUID.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        class_2300 entitySelector;
        try {
            entitySelector = (class_2300)context.getArgument("target", class_2300.class);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get entity target selector from context {}:", context, (Object)e);
            return class_2172.method_9265(new HashSet(), (SuggestionsBuilder)suggestionsBuilder);
        }
        UUID entityUUID = ReflectionUtils.getUUIDValueField((Object)entitySelector, new String[]{"entityUUID", "entity", "field_10821", "f_121121_"});
        if (entityUUID == null) {
            log.error("Failed to get entity UUID from entity selector {} and context {}", (Object)entitySelector, context);
        }
        if (entityUUID != null && DialogDataManager.hasDialogDataSet(entityUUID)) {
            DialogDataSet dialogDataSet = DialogDataManager.getDialogDataSet(entityUUID);
            Map<String, DialogDataEntry> dialogDataEntries = dialogDataSet.getDialogByLabelMap();
            this.dialogDataEntriesCache = dialogDataEntries;
            return class_2172.method_9265(dialogDataEntries.keySet(), (SuggestionsBuilder)suggestionsBuilder);
        }
        return class_2172.method_9265(new HashSet(), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

