/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_7923;

public class EntityTypeSuggestions {
    private static final Set<String> deniedEntityTypes = Set.of("minecraft:area_effect_cloud", "minecraft:armor_stand", "minecraft:arrow", "minecraft:boat", "minecraft:block_display", "minecraft:chest_minecart", "minecraft:chest_boat", "minecraft:command_block_minecart", "minecraft:dragon_fireball", "minecraft:egg", "minecraft:ender_dragon", "minecraft:end_crystal", "minecraft:ender_pearl", "minecraft:evoker_fangs", "minecraft:experience_bottle", "minecraft:experience_orb", "minecraft:eye_of_ender", "minecraft:falling_block", "minecraft:fireball", "minecraft:firework_rocket", "minecraft:fishing_bobber", "minecraft:furnace_minecart", "minecraft:glow_item_frame", "minecraft:hopper_minecart", "minecraft:item", "minecraft:item_frame", "minecraft:interaction", "minecraft:leash_knot", "minecraft:lightning_bolt", "minecraft:llama_spit", "minecraft:marker", "minecraft:minecart", "minecraft:mooshroom", "minecraft:painting", "minecraft:potion", "minecraft:shulker_bullet", "minecraft:small_fireball", "minecraft:snowball", "minecraft:spawner_minecart", "minecraft:spectral_arrow", "minecraft:text_display", "minecraft:tnt", "minecraft:tnt_minecart", "minecraft:trident", "minecraft:wither_skull");
    private static List<String> filteredEntityTypes;

    private EntityTypeSuggestions() {
    }

    public static CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder build) {
        return class_2172.method_9264(EntityTypeSuggestions.getFilteredEntityTypes(), (SuggestionsBuilder)build);
    }

    private static Stream<String> getFilteredEntityTypes() {
        if (filteredEntityTypes == null) {
            filteredEntityTypes = class_7923.field_41177.method_10235().stream().filter(entityType -> {
                String entityTypeName = entityType.toString();
                return !entityTypeName.startsWith("easy_npc") && !deniedEntityTypes.contains(entityType.toString());
            }).map(entityType -> "\"" + entityType + "\"").toList();
        }
        return filteredEntityTypes.stream();
    }
}

