/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.configuration;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public enum ConfigurationType {
    NONE,
    ABILITIES_ATTRIBUTE,
    ADVANCED_DIALOG,
    ADVANCED_POSE,
    ADVANCED_TRADING,
    ATTACK_OBJECTIVE,
    BASE_ATTRIBUTE,
    BASIC_ACTION,
    BASIC_DIALOG,
    BASIC_OBJECTIVE,
    BASIC_TRADING,
    CUSTOM_MODEL,
    CUSTOM_POSE,
    CUSTOM_PRESET_EXPORT,
    CUSTOM_PRESET_IMPORT,
    CUSTOM_SKIN,
    CUSTOM_TRADING,
    DEFAULT_MODEL,
    DEFAULT_POSE,
    DEFAULT_POSITION,
    DEFAULT_PRESET_IMPORT,
    DEFAULT_ROTATION,
    DEFAULT_SKIN,
    DIALOG(true),
    DIALOG_ACTION,
    DISPLAY_ATTRIBUTE,
    DISTANCE_ACTION,
    EQUIPMENT,
    FOLLOW_OBJECTIVE,
    LOCAL_PRESET_IMPORT,
    LOOK_OBJECTIVE,
    MAIN,
    NONE_DIALOG,
    NONE_SKIN,
    NONE_TRADING,
    PLAYER_SKIN,
    POSE(true),
    SCALING,
    SKIN(true),
    TRADING(true),
    URL_SKIN,
    WORLD_PRESET_EXPORT,
    WORLD_PRESET_IMPORT,
    YES_NO_DIALOG;

    private boolean isAlias = false;

    private ConfigurationType() {
    }

    private ConfigurationType(boolean isAlias) {
        this.isAlias = isAlias;
    }

    public static ConfigurationType get(String configurationType) {
        if (configurationType == null || configurationType.isEmpty()) {
            return NONE;
        }
        try {
            return ConfigurationType.valueOf(configurationType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public class_2960 getId() {
        return new class_2960("easy_npc", this.name().toLowerCase(Locale.ROOT) + "_configuration");
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_configuration";
    }

    public class_2561 getConfigurationTitle(EasyNPC<?> easyNPC) {
        String translationKey = "text.easy_npc.config." + this.name().toLowerCase(Locale.ROOT) + ".title";
        return TextComponent.getTranslatedTextRaw(translationKey, easyNPC.getEntity().method_5477().method_10858(16));
    }
}

