/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public interface ModelVisibilityData<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_MODEL_VISIBLE_TAG = "Visible";

    public static void registerSyncedModelVisibilityData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Model Visibility Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_HEAD_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_BODY_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_ARMS_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_HELMET_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
        map.put(SynchedDataIndex.MODEL_BOOTS_VISIBLE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13323));
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    public boolean canUseArmor();

    default public boolean isModelPartVisible(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.isModelHeadVisible();
            case ModelPart.BODY -> this.isModelBodyVisible();
            case ModelPart.ARMS -> this.isModelArmsVisible();
            case ModelPart.LEFT_ARM -> this.isModelLeftArmVisible();
            case ModelPart.RIGHT_ARM -> this.isModelRightArmVisible();
            case ModelPart.LEFT_LEG -> this.isModelLeftLegVisible();
            case ModelPart.RIGHT_LEG -> this.isModelRightLegVisible();
            default -> false;
        };
    }

    default public boolean isModelEquipmentVisible(class_1304 equipmentSlot) {
        if (equipmentSlot == null || !this.canUseArmor()) {
            return false;
        }
        return switch (equipmentSlot) {
            case class_1304.field_6169 -> this.isModelHelmetVisible();
            case class_1304.field_6174 -> this.isModelChestplateVisible();
            case class_1304.field_6172 -> this.isModelLeggingsVisible();
            case class_1304.field_6166 -> this.isModelBootsVisible();
            default -> false;
        };
    }

    default public void setModelPartVisible(ModelPart modelPart, boolean visible) {
        if (modelPart == ModelPart.ROOT) {
            return;
        }
        switch (modelPart) {
            case HEAD: {
                this.setModelHeadVisible(visible);
                break;
            }
            case BODY: {
                this.setModelBodyVisible(visible);
                break;
            }
            case ARMS: {
                this.setModelArmsVisible(visible);
                break;
            }
            case LEFT_ARM: {
                this.setModelLeftArmVisible(visible);
                break;
            }
            case RIGHT_ARM: {
                this.setModelRightArmVisible(visible);
                break;
            }
            case LEFT_LEG: {
                this.setModelLeftLegVisible(visible);
                break;
            }
            case RIGHT_LEG: {
                this.setModelRightLegVisible(visible);
                break;
            }
            default: {
                log.error("Invalid visible model part {} for {}", (Object)modelPart, (Object)this);
            }
        }
    }

    default public boolean hasChangedModelVisibility() {
        return this.hasHeadModelPart() && !this.isModelHeadVisible() || this.hasBodyModelPart() && !this.isModelBodyVisible() || this.hasArmsModelPart() && !this.isModelArmsVisible() || this.hasLeftArmModelPart() && !this.isModelLeftArmVisible() || this.hasRightArmModelPart() && !this.isModelRightArmVisible() || this.hasLeftLegModelPart() && !this.isModelLeftLegVisible() || this.hasRightLegModelPart() && !this.isModelRightLegVisible();
    }

    default public boolean isModelHeadVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_VISIBLE);
    }

    default public void setModelHeadVisible(boolean modelHeadVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_VISIBLE, modelHeadVisible);
    }

    default public boolean isModelBodyVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_VISIBLE);
    }

    default public void setModelBodyVisible(boolean modelBodyVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_VISIBLE, modelBodyVisible);
    }

    default public boolean isModelArmsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_VISIBLE);
    }

    default public void setModelArmsVisible(boolean modelArmsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_VISIBLE, modelArmsVisible);
    }

    default public boolean isModelLeftArmVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE);
    }

    default public void setModelLeftArmVisible(boolean modelLeftArmVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, modelLeftArmVisible);
    }

    default public boolean isModelRightArmVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE);
    }

    default public void setModelRightArmVisible(boolean modelRightArmVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, modelRightArmVisible);
    }

    default public boolean isModelLeftLegVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE);
    }

    default public void setModelLeftLegVisible(boolean modelLeftLegVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, modelLeftLegVisible);
    }

    default public boolean isModelRightLegVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE);
    }

    default public void setModelRightLegVisible(boolean modelRightLegVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, modelRightLegVisible);
    }

    default public boolean isModelHelmetVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_HELMET_VISIBLE);
    }

    default public void setModelHelmetVisible(boolean modelHelmetVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HELMET_VISIBLE, modelHelmetVisible);
    }

    default public boolean isModelChestplateVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE);
    }

    default public void setModelChestplateVisible(boolean modelChestplateVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, modelChestplateVisible);
    }

    default public boolean isModelLeggingsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE);
    }

    default public void setModelLeggingsVisible(boolean modelLeggingsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, modelLeggingsVisible);
    }

    default public boolean isModelBootsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_BOOTS_VISIBLE);
    }

    default public void setModelBootsVisible(boolean modelBootsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BOOTS_VISIBLE, modelBootsVisible);
    }

    default public void defineSynchedModelVisibilityData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_HEAD_VISIBLE, this.hasHeadModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_BODY_VISIBLE, this.hasBodyModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ARMS_VISIBLE, this.hasArmsModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, this.hasLeftArmModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, this.hasRightArmModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, this.hasLeftLegModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, this.hasRightLegModelPart());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_HELMET_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_BOOTS_VISIBLE, this.canUseArmor());
    }

    default public void addAdditionalModelVisibilityData(class_2487 compoundTag) {
        class_2487 visibilityTag = new class_2487();
        if (this.isModelHeadVisible() != this.hasHeadModelPart()) {
            visibilityTag.method_10556(ModelPart.HEAD.getTagName(), this.isModelHeadVisible());
        }
        if (this.isModelBodyVisible() != this.hasBodyModelPart()) {
            visibilityTag.method_10556(ModelPart.BODY.getTagName(), this.isModelBodyVisible());
        }
        if (this.isModelArmsVisible() != this.hasArmsModelPart()) {
            visibilityTag.method_10556(ModelPart.ARMS.getTagName(), this.isModelArmsVisible());
        }
        if (this.isModelLeftArmVisible() != this.hasLeftArmModelPart()) {
            visibilityTag.method_10556(ModelPart.LEFT_ARM.getTagName(), this.isModelLeftArmVisible());
        }
        if (this.isModelRightArmVisible() != this.hasRightArmModelPart()) {
            visibilityTag.method_10556(ModelPart.RIGHT_ARM.getTagName(), this.isModelRightArmVisible());
        }
        if (this.isModelLeftLegVisible() != this.hasLeftLegModelPart()) {
            visibilityTag.method_10556(ModelPart.LEFT_LEG.getTagName(), this.isModelLeftLegVisible());
        }
        if (this.isModelRightLegVisible() != this.hasRightLegModelPart()) {
            visibilityTag.method_10556(ModelPart.RIGHT_LEG.getTagName(), this.isModelRightLegVisible());
        }
        if (this.isModelHelmetVisible() != this.canUseArmor()) {
            visibilityTag.method_10556(ModelPart.HELMET.getTagName(), this.isModelHelmetVisible());
        }
        if (this.isModelChestplateVisible() != this.canUseArmor()) {
            visibilityTag.method_10556(ModelPart.CHESTPLATE.getTagName(), this.isModelChestplateVisible());
        }
        if (this.isModelLeggingsVisible() != this.canUseArmor()) {
            visibilityTag.method_10556(ModelPart.LEGGINGS.getTagName(), this.isModelLeggingsVisible());
        }
        if (this.isModelBootsVisible() != this.canUseArmor()) {
            visibilityTag.method_10556(ModelPart.BOOTS.getTagName(), this.isModelBootsVisible());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_VISIBLE_TAG, (class_2520)visibilityTag);
    }

    default public void readAdditionalModelVisibilityData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_VISIBLE_TAG)) {
            return;
        }
        class_2487 visibilityTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_VISIBLE_TAG);
        if (visibilityTag.method_10545(ModelPart.HEAD.getTagName())) {
            this.setModelHeadVisible(visibilityTag.method_10577(ModelPart.HEAD.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.BODY.getTagName())) {
            this.setModelBodyVisible(visibilityTag.method_10577(ModelPart.BODY.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.ARMS.getTagName())) {
            this.setModelArmsVisible(visibilityTag.method_10577(ModelPart.ARMS.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmVisible(visibilityTag.method_10577(ModelPart.LEFT_ARM.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmVisible(visibilityTag.method_10577(ModelPart.RIGHT_ARM.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegVisible(visibilityTag.method_10577(ModelPart.LEFT_LEG.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegVisible(visibilityTag.method_10577(ModelPart.RIGHT_LEG.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.HELMET.getTagName())) {
            this.setModelHelmetVisible(visibilityTag.method_10577(ModelPart.HELMET.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.CHESTPLATE.getTagName())) {
            this.setModelChestplateVisible(visibilityTag.method_10577(ModelPart.CHESTPLATE.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.LEGGINGS.getTagName())) {
            this.setModelLeggingsVisible(visibilityTag.method_10577(ModelPart.LEGGINGS.getTagName()));
        }
        if (visibilityTag.method_10545(ModelPart.BOOTS.getTagName())) {
            this.setModelBootsVisible(visibilityTag.method_10577(ModelPart.BOOTS.getTagName()));
        }
    }
}

