/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionGroup;
import de.markusbordihn.easynpc.data.action.ActionManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public interface ActionHandler<E extends class_1314>
extends EasyNPC<E> {
    public static final Set<String> BLOCKED_UNSAFE_NPC_COMMANDS = new HashSet<String>(List.of("ban-ip", "ban", "banlist", "debug", "deop", "difficulty", "forceload", "gamerule", "kick", "op", "pardon", "reload", "save-all", "save-off", "save-on", "setidletimeout", "setworldspawn", "stop", "whitelist"));

    private static boolean isBlockedUnsafeNPCCommand(String command) {
        String[] runParts;
        String relevant;
        if (command == null || command.isBlank()) {
            return false;
        }
        String cmd = command.trim();
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        if ((relevant = (runParts = cmd.split("\\s+run\\s+"))[runParts.length - 1].trim()).startsWith("/")) {
            relevant = relevant.substring(1);
        }
        String mainCmd = relevant.split(" ")[0].toLowerCase(Locale.ROOT);
        return BLOCKED_UNSAFE_NPC_COMMANDS.contains(mainCmd);
    }

    private static boolean validateActionData(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        return actionDataEntry != null && serverPlayer != null && actionDataEntry.isValidAndNotEmpty() && !serverPlayer.method_37908().method_8608();
    }

    public static void executeEntityCommand(String command, class_1297 entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = entity.method_5682();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for entity {}", (Object)entity);
            return;
        }
        if (ActionHandler.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe entity command {} for {} with permission level {}!", (Object)command, (Object)entity, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        class_2170 commands = minecraftServer.method_3734();
        class_2168 commandSourceStack = minecraftServer.method_3739().method_9232(entity).method_9208(entity.method_19538()).method_9216(entity.method_5802()).method_9206(permissionLevel);
        CommandDispatcher commandDispatcher = commands.method_9235();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.method_9217()));
        commands.method_9249(parseResults, command);
    }

    public static void executePlayerCommand(String command, class_3222 serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for player {}", (Object)serverPlayer);
            return;
        }
        if (ActionHandler.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe player command {} for {} with permission level {}!", (Object)command, (Object)serverPlayer, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        class_2170 commands = minecraftServer.method_3734();
        class_2168 commandSourceStack = minecraftServer.method_3739().method_9232((class_1297)serverPlayer).method_9208(serverPlayer.method_19538()).method_9216(serverPlayer.method_5802()).method_9206(permissionLevel).method_9227(serverPlayer.method_51469());
        CommandDispatcher commandDispatcher = commands.method_9235();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.method_9217()));
        commands.method_9249(parseResults, command);
    }

    default public List<? extends class_1657> getPlayersInRange(Double range) {
        class_1297 entity = this.getEntity();
        return this.getLevel().method_18456().stream().filter(class_1301.field_6155).filter(targetPlayers -> entity.method_24516((class_1297)targetPlayers, range.doubleValue())).toList();
    }

    default public void checkTradingActions() {
        this.getProfiler().method_15396("npcCheckTradingActions");
        TradingData tradingData = this.getEasyNPCTradingData();
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tradingData == null || tickerData == null) {
            return;
        }
        this.getProfiler().method_15407();
    }

    default public void checkDistanceActions() {
        class_3222 serverPlayer;
        ActionDataEntry actionDataEntry;
        List<class_1657> listOfPlayers;
        this.getProfiler().method_15396("npcCheckDistanceActions");
        class_1308 mob = this.getMob();
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null || mob == null || mob.method_29504()) {
            return;
        }
        boolean skipPlayerDistanceCheck = false;
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_NEAR)) {
            listOfPlayers = this.getPlayersInRange(16.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_NEAR);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_NEAR);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_CLOSE)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(8.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_CLOSE);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(4.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_VERY_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_TOUCH)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(1.25);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_TOUCH);
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_TOUCH);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer);
                }
            }
        }
        this.getProfiler().method_15407();
    }

    default public void interactWithBlock(class_2338 blockPos) {
        class_1309 livingEntity = this.getLivingEntity();
        if (livingEntity != null && !this.method_38069()) {
            this.lookAtBlock(blockPos);
            livingEntity.method_6104(class_1268.field_5808);
            this.getServerLevel().method_8320(blockPos).method_26174((class_1937)this.getServerLevel(), (class_1657)this.getFakePlayer(this.getServerLevel(), blockPos), class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)blockPos), class_2350.field_11033, blockPos, false));
            livingEntity.method_6047().method_7913((class_1937)this.getServerLevel(), (class_1657)this.getFakePlayer(this.getServerLevel(), blockPos), class_1268.field_5808);
        }
    }

    default public void lookAtBlock(class_2338 target) {
        class_1297 entity = this.getEntity();
        class_243 vec3d = entity.method_19538();
        class_243 targetVec = class_243.method_24953((class_2382)target);
        class_243 delta = targetVec.method_1020(vec3d);
        double horizontalDistance = delta.method_37267();
        entity.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)delta.field_1351, (double)horizontalDistance) * 57.29577951308232)))));
        entity.method_5636(class_3532.method_15393((float)((float)(class_3532.method_15349((double)delta.field_1350, (double)delta.field_1352) * 57.29577951308232) - 90.0f)));
        entity.method_5847(entity.method_5791());
    }

    default public void executeActions(ActionDataSet actionDataSet, class_3222 serverPlayer) {
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            return;
        }
        ActionDataEntry closeDialogAction = null;
        boolean hasScreenAction = false;
        for (ActionDataEntry actionDataEntry : actionDataSet.getEntries()) {
            ActionDataType actionType = actionDataEntry.actionDataType();
            if (actionType == ActionDataType.CLOSE_DIALOG) {
                if (closeDialogAction == null) {
                    closeDialogAction = actionDataEntry;
                    continue;
                }
                log.warn("Multiple close dialog actions found in action data set {}!", (Object)actionDataSet);
                continue;
            }
            if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG || actionType == ActionDataType.OPEN_NAMED_DIALOG || actionType == ActionDataType.OPEN_TRADING_SCREEN) {
                if (hasScreenAction) {
                    log.debug("Ignoring {}. Multiple screen actions found in action data set {}! Only the first valid will be executed.", (Object)actionType, (Object)actionDataSet);
                    continue;
                }
                if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG && !this.getEasyNPCDialogData().hasDialog() || actionType == ActionDataType.OPEN_NAMED_DIALOG && !this.getEasyNPCDialogData().hasDialog(actionDataEntry.command()) || actionType == ActionDataType.OPEN_TRADING_SCREEN && !this.getEasyNPCTradingData().hasTradingData()) {
                    log.debug("Ignoring {} action because no data is available.", (Object)actionType);
                    continue;
                }
                hasScreenAction = true;
            }
            this.executeAction(actionDataEntry, serverPlayer);
        }
        if (closeDialogAction != null) {
            this.executeAction(closeDialogAction, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        switch (actionDataEntry.actionDataType()) {
            case NONE: {
                break;
            }
            case COMMAND: {
                if (actionDataEntry.executeAsUser()) {
                    this.executePlayerCommand(actionDataEntry, serverPlayer);
                    break;
                }
                this.executeEntityCommand(actionDataEntry, serverPlayer);
                break;
            }
            case CLOSE_DIALOG: {
                serverPlayer.method_7346();
                break;
            }
            case INTERACT_BLOCK: {
                class_2338 blockPos = actionDataEntry.blockPos();
                if (blockPos != null && !blockPos.equals((Object)class_2338.field_10980)) {
                    this.interactWithBlock(blockPos);
                    break;
                }
                log.error("No block position found for action {}", (Object)actionDataEntry);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                this.openDefaultDialog(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_NAMED_DIALOG: {
                this.openNamedDialog(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_TRADING_SCREEN: {
                TradingData tradingData = this.getEasyNPCTradingData();
                if (tradingData != null) {
                    tradingData.openTradingScreen(serverPlayer);
                    break;
                }
                log.error("No trading data found for action {}", (Object)actionDataEntry);
                break;
            }
            default: {
                log.warn("Unknown action type {} for action {}", (Object)actionDataEntry.actionDataType(), (Object)actionDataEntry);
            }
        }
    }

    default public void openDefaultDialog(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        DialogData dialogData = this.getEasyNPCDialogData();
        if (dialogData != null) {
            dialogData.openDefaultDialog(serverPlayer);
        } else {
            log.error("No dialog data found for action {}", (Object)actionDataEntry);
            serverPlayer.method_7346();
        }
    }

    default public void openNamedDialog(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        String dialogLabel = actionDataEntry.command();
        DialogData dialogData = this.getEasyNPCDialogData();
        if (dialogLabel != null && !dialogLabel.isEmpty() && dialogData != null && dialogData.hasDialog(dialogLabel)) {
            UUID dialogId = dialogData.getDialogId(dialogLabel);
            dialogData.openDialog(serverPlayer, dialogId);
        } else {
            log.error("Unknown dialog label {} for action {}", (Object)dialogLabel, (Object)actionDataEntry);
            serverPlayer.method_7346();
        }
    }

    default public void executePlayerCommand(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int userPermissionLevel = actionDataEntry.permissionLevel();
        if (userPermissionLevel > actionEventData.getActionPermissionLevel()) {
            log.warn("User permission level {} is lower than action permission level {} for action {}", (Object)actionEventData.getActionPermissionLevel(), (Object)userPermissionLevel, (Object)actionDataEntry);
            userPermissionLevel = actionEventData.getActionPermissionLevel();
        }
        log.debug("Try to execute action {} as user {} with user permission level {} of requested action permission level {} ...", (Object)actionDataEntry, (Object)serverPlayer, (Object)userPermissionLevel, (Object)actionDataEntry.permissionLevel());
        ActionHandler.executePlayerCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), serverPlayer, userPermissionLevel, actionDataEntry.enableDebug());
    }

    default public void executeEntityCommand(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int ownerPermissionLevel = actionEventData.getActionPermissionLevel();
        if (ownerPermissionLevel > 3) {
            ownerPermissionLevel = 3;
        } else if (ownerPermissionLevel <= 0) {
            ownerPermissionLevel = 1;
        }
        log.debug("Try to execute action {} as entity {} with owner permission level {} of max. {} ...", (Object)actionDataEntry, (Object)this.getEntity(), (Object)ownerPermissionLevel, (Object)actionEventData.getActionPermissionLevel());
        ActionHandler.executeEntityCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), this.getEntity(), ownerPermissionLevel, actionDataEntry.enableDebug());
    }
}

