/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributes;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributeType;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributes;
import de.markusbordihn.easynpc.data.attribute.MovementAttributeType;
import de.markusbordihn.easynpc.data.attribute.MovementAttributes;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private AttributeHandler() {
    }

    public static boolean setCombatAttribute(EasyNPC<?> easyNPC, CombatAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        CombatAttributes attributes = entityAttributes.getCombatAttributes();
        log.debug("Changing combat attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case IS_ATTACKABLE: {
                entityAttributes.setCombatAttributes(attributes.withIsAttackable(value));
                if (easyNPC.getEntity() == null) break;
                easyNPC.getEntity().method_5684(!value);
                break;
            }
            default: {
                log.error("Unimplemented combat attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setCombatAttribute(EasyNPC<?> easyNPC, CombatAttributeType attributeType, double value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        CombatAttributes attributes = entityAttributes.getCombatAttributes();
        log.debug("Changing combat attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case HEALTH_REGENERATION: {
                entityAttributes.setCombatAttributes(attributes.withHealthRegeneration(value));
                break;
            }
            default: {
                log.error("Unimplemented combat attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setEnvironmentalAttribute(EasyNPC<?> easyNPC, EnvironmentalAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        EnvironmentalAttributes attributes = entityAttributes.getEnvironmentalAttributes();
        ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        log.debug("Changing environmental attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_BREATHE_UNDERWATER: {
                entityAttributes.setEnvironmentalAttributes(attributes.withCanBreathUnderwater(value));
                break;
            }
            case CAN_FLOAT: {
                entityAttributes.setEnvironmentalAttributes(attributes.withCanFloat(value));
                if (objectiveData != null) {
                    objectiveData.registerAttributeBasedObjectives();
                }
                if (navigationData == null) break;
                navigationData.refreshGroundNavigation();
                break;
            }
            case FREEFALL: {
                entityAttributes.setEnvironmentalAttributes(attributes.withFreefall(value));
                break;
            }
            default: {
                log.error("Unimplemented environmental attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setInteractionAttribute(EasyNPC<?> easyNPC, InteractionAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        InteractionAttributes attributes = entityAttributes.getInteractionAttributes();
        log.debug("Changing interaction attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_BE_LEASHED: {
                entityAttributes.setInteractionAttributes(attributes.withCanBeLeashed(value));
                break;
            }
            case IS_PUSHABLE: {
                entityAttributes.setInteractionAttributes(attributes.withIsPushable(value));
                break;
            }
            case PUSH_ENTITIES: {
                entityAttributes.setInteractionAttributes(attributes.withPushEntities(value));
                break;
            }
            default: {
                log.error("Unimplemented interaction attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setMovementAttribute(EasyNPC<?> easyNPC, MovementAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        MovementAttributes attributes = entityAttributes.getMovementAttributes();
        ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        log.debug("Changing moving attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_CLOSE_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanCloseDoor(value));
                break;
            }
            case CAN_OPEN_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanOpenDoor(value));
                break;
            }
            case CAN_PASS_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanPassDoor(value));
                break;
            }
            case CAN_USE_NETHER_PORTAL: {
                entityAttributes.setMovementAttributes(attributes.withCanUseNetherPortal(value));
                break;
            }
            default: {
                log.error("Unimplemented moving attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        if (objectiveData != null) {
            objectiveData.registerAttributeBasedObjectives();
        }
        if (navigationData != null) {
            navigationData.refreshGroundNavigation();
        }
        return true;
    }

    public static boolean setEntityAttribute(EasyNPC<?> easyNPC, EntityAttribute entityAttribute, boolean value) {
        if (easyNPC == null || entityAttribute == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
            NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
            switch (entityAttribute) {
                case SILENT: {
                    log.debug("Change silent={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeSilent(value);
                    break;
                }
                default: {
                    log.error("Unimplemented entity attribute {} for {}", (Object)entityAttribute, easyNPC);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean setBaseAttribute(EasyNPC<?> easyNPC, class_2960 attribute, Double value) {
        if (easyNPC == null || attribute == null || value == null) {
            return false;
        }
        AttributeData<?> attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            switch (attribute.toString()) {
                case "minecraft:generic.max_health": {
                    attributeData.setBaseAttribute(class_5134.field_23716, value);
                    class_1309 livingEntity = easyNPC.getLivingEntity();
                    if (livingEntity == null) break;
                    livingEntity.method_6033(value.floatValue());
                    break;
                }
                case "minecraft:generic.follow_range": {
                    attributeData.setBaseAttribute(class_5134.field_23717, value);
                    break;
                }
                case "minecraft:generic.knockback_resistance": {
                    attributeData.setBaseAttribute(class_5134.field_23718, value);
                    break;
                }
                case "minecraft:generic.movement_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23719, value);
                    break;
                }
                case "minecraft:generic.flying_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23720, value);
                    break;
                }
                case "minecraft:generic.attack_damage": {
                    attributeData.setBaseAttribute(class_5134.field_23721, value);
                    break;
                }
                case "minecraft:generic.attack_knockback": {
                    attributeData.setBaseAttribute(class_5134.field_23722, value);
                    break;
                }
                case "minecraft:generic.attack_speed": {
                    attributeData.setBaseAttribute(class_5134.field_23723, value);
                    break;
                }
                case "minecraft:generic.armor": {
                    attributeData.setBaseAttribute(class_5134.field_23724, value);
                    break;
                }
                case "minecraft:generic.armor_toughness": {
                    attributeData.setBaseAttribute(class_5134.field_23725, value);
                    break;
                }
                case "minecraft:generic.luck": {
                    attributeData.setBaseAttribute(class_5134.field_23726, value);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

