/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.animation.SmartAnimations;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EquipmentHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private EquipmentHandler() {
    }

    public static void setHandSlotItem(EasyNPC<?> easyNPC, class_1268 interactionHand, class_1799 itemStack) {
        EquipmentHandler.setEquipmentSlotItem(easyNPC, interactionHand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171, itemStack);
    }

    public static void setArmorSlotItem(EasyNPC<?> easyNPC, class_1304 equipmentSlot, class_1799 itemStack) {
        EquipmentHandler.setEquipmentSlotItem(easyNPC, equipmentSlot, itemStack);
    }

    public static boolean setEquipmentSlotItem(EasyNPC<?> easyNPC, class_1304 equipmentSlot, class_1799 itemStack) {
        if (easyNPC == null || equipmentSlot == null || itemStack == null) {
            log.error("[{}] Error setting owner ", easyNPC);
            return false;
        }
        class_1309 livingEntity = easyNPC.getLivingEntity();
        log.debug("[{}] Setting equipment slot {} to {}", easyNPC, (Object)equipmentSlot, (Object)itemStack);
        switch (equipmentSlot) {
            case field_6173: {
                livingEntity.method_6122(class_1268.field_5808, itemStack);
                break;
            }
            case field_6171: {
                livingEntity.method_6122(class_1268.field_5810, itemStack);
                break;
            }
            case field_6169: 
            case field_6174: 
            case field_6172: 
            case field_6166: {
                livingEntity.method_5673(equipmentSlot, itemStack);
                break;
            }
            default: {
                log.error("[{}] Equipment slot {} is not supported!", easyNPC, (Object)equipmentSlot);
                return false;
            }
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        class_1792 item = itemStack.method_7909();
        if (modelData != null && modelData.supportsSmartAnimations() && modelData.getModelSupportsSmartAnimations()) {
            boolean hasItemInMainHand;
            boolean bl = hasItemInMainHand = !livingEntity.method_6047().method_7960() || !livingEntity.method_6079().method_7960();
            if (hasItemInMainHand && !class_1802.field_8162.equals(item) && !SmartAnimations.itemSupportSmartAnimation(item)) {
                log.debug("[{}] Disable smart animations for item {}", easyNPC, (Object)item);
                modelData.setItemSupportsSmartAnimations(false);
            } else if (!hasItemInMainHand && !modelData.getItemSupportsSmartAnimations()) {
                log.debug("[{}] Re-Enable smart animations for item {}", easyNPC, (Object)item);
                modelData.setItemSupportsSmartAnimations(true);
            }
        }
        return true;
    }
}

