/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import net.minecraft.class_1309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OwnerHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private OwnerHandler() {
    }

    public static boolean setOwner(EasyNPC<?> easyNPC, class_1309 owner) {
        ObjectiveDataEntry objectiveDataEntry;
        if (easyNPC == null || owner == null) {
            log.error("[{}] Error setting owner!", easyNPC);
            return false;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null) {
            log.error("[{}] No owner data available for setting owner!", easyNPC);
            return false;
        }
        if (ownerData.method_35057() != null && ownerData.isOwnedBy(owner)) {
            log.debug("[{}] Owner is already set to {}!", easyNPC, (Object)owner);
            return true;
        }
        log.debug("[{}] Setting owner to {}", easyNPC, (Object)owner);
        ownerData.setOwnerUUID(owner.method_5667());
        ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null && objectiveData.hasObjective(ObjectiveType.FOLLOW_OWNER) && ((objectiveDataEntry = objectiveData.getObjective(ObjectiveType.FOLLOW_OWNER)).getTargetOwnerUUID() == null || objectiveDataEntry.getTargetOwnerUUID() != owner.method_5667())) {
            log.debug("[{}] Update follow owner objective to {}", easyNPC, (Object)owner);
            objectiveDataEntry.setTargetOwnerUUID(owner.method_5667());
            objectiveData.removeObjective(ObjectiveType.FOLLOW_OWNER);
            objectiveData.addObjective(objectiveDataEntry);
        }
        return true;
    }

    public static boolean removeOwner(EasyNPC<?> easyNPC) {
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null) {
            log.error("[{}] No owner data available for setting owner!", easyNPC);
            return false;
        }
        if (ownerData.method_6139() == null) {
            log.debug("[{}] Owner is already removed!", easyNPC);
            return true;
        }
        log.debug("[{}] Removing owner ...", easyNPC);
        ownerData.setOwner(null);
        return true;
    }
}

