/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkHandler
implements NetworkHandlerInterface {
    private final Map<class_2960, Class<? extends NetworkMessageRecord>> clientMessages = new LinkedHashMap<class_2960, Class<? extends NetworkMessageRecord>>();
    private final Map<class_2960, Class<? extends NetworkMessageRecord>> serverMessages = new LinkedHashMap<class_2960, Class<? extends NetworkMessageRecord>>();
    private final Map<class_2960, Class<? extends NetworkMessageRecord>> registeredClientMessages = new LinkedHashMap<class_2960, Class<? extends NetworkMessageRecord>>();
    private final Map<class_2960, Class<? extends NetworkMessageRecord>> registeredServerMessages = new LinkedHashMap<class_2960, Class<? extends NetworkMessageRecord>>();

    public NetworkHandler() {
        log.info("{} NetworkHandler with version {}", (Object)"\ud83d\udde3 Register Easy NPC", (Object)23);
    }

    public void sendToServer(NetworkMessageRecord networkMessageRecord) {
        ClientPlayNetworking.send((class_2960)networkMessageRecord.id(), (class_2540)networkMessageRecord.payload());
    }

    public void sendToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)networkMessageRecord.id(), (class_2540)networkMessageRecord.payload());
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(class_2960 messageID, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        if (!ClientPlayNetworking.registerGlobalReceiver((class_2960)messageID, (client, channelHandler, buffer, responseSender) -> {
            NetworkMessageRecord networkMessage = (NetworkMessageRecord)creator.apply(buffer);
            client.execute(networkMessage::handleClient);
        })) {
            log.error("Failed to register client network message handler for {}", (Object)messageID);
        } else {
            this.logRegisterClientNetworkMessageHandler(messageID, networkMessageRecord);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(class_2960 messageID, Class<M> networkMessageRecord, Function<class_2540, M> creator) {
        if (!ServerPlayNetworking.registerGlobalReceiver((class_2960)messageID, (server, serverPlayer, channelHandler, buffer, responseSender) -> {
            NetworkMessageRecord networkMessage = (NetworkMessageRecord)creator.apply(buffer);
            server.execute(() -> networkMessage.handleServer(serverPlayer));
        })) {
            log.error("Failed to register server network message handler for {}", (Object)messageID);
        } else {
            this.logRegisterServerNetworkMessageHandler(messageID, networkMessageRecord);
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void addClientMessage(class_2960 messageID, Class<M> networkMessage) {
        this.clientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addServerMessage(class_2960 messageID, Class<M> networkMessage) {
        this.serverMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<class_2960, Class<? extends NetworkMessageRecord>> getClientMessages() {
        return this.clientMessages;
    }

    @Override
    public Map<class_2960, Class<? extends NetworkMessageRecord>> getServerMessages() {
        return this.serverMessages;
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(class_2960 messageID, Class<M> networkMessage) {
        this.registeredClientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(class_2960 messageID, Class<M> networkMessage) {
        this.registeredServerMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<class_2960, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages() {
        return this.registeredClientMessages;
    }

    @Override
    public Map<class_2960, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages() {
        return this.registeredServerMessages;
    }
}

