/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeBasicTradingMessage(UUID uuid, TradingValueType tradingValueType, int tradingValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_basic_trading");

    public static ChangeBasicTradingMessage create(class_2540 buffer) {
        return new ChangeBasicTradingMessage(buffer.method_10790(), (TradingValueType)buffer.method_10818(TradingValueType.class), buffer.readInt());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.tradingValueType);
        buffer.writeInt(this.tradingValue);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingValueType == null) {
            log.error("Trading value type is unknown for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.tradingValue < 0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)this.tradingValue, (Object)this.tradingValueType, (Object)serverPlayer);
            return;
        }
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.tradingValueType) {
            case RESET_TRADING_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)this.tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setResetsEveryMin(this.tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set max uses to {} for {} from {}", (Object)this.tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setMaxUses(this.tradingValue);
                tradingData.updateBasicTradingOffers();
                break;
            }
            case REWARD_EXP: {
                log.debug("Set reward exp to {} for {} from {}", (Object)this.tradingValue, easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setRewardedXP(this.tradingValue);
                tradingData.updateBasicTradingOffers();
                break;
            }
            default: {
                log.error("Trading value type {} is unknown for {}", (Object)this.tradingValueType, (Object)serverPlayer);
            }
        }
    }
}

