/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttributeValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, EntityAttributeValueType valueType, boolean booleanValue, double doubleValue, int integerValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_combat_attribute");

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, EntityAttributeValueType.BOOLEAN, value, 0.0, 0);
    }

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Double value) {
        this(uuid, attributeType, EntityAttributeValueType.DOUBLE, false, value, 0);
    }

    public static ChangeCombatAttributeMessage create(class_2540 buffer) {
        return new ChangeCombatAttributeMessage(buffer.method_10790(), (CombatAttributeType)buffer.method_10818(CombatAttributeType.class), (EntityAttributeValueType)buffer.method_10818(EntityAttributeValueType.class), buffer.readBoolean(), buffer.readDouble(), buffer.readInt());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.attributeType);
        buffer.method_10817((Enum)this.valueType);
        buffer.writeBoolean(this.booleanValue);
        buffer.writeDouble(this.doubleValue);
        buffer.writeInt(this.integerValue);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.valueType) {
            case BOOLEAN: {
                AttributeHandler.setCombatAttribute(easyNPC, this.attributeType, Boolean.TRUE.equals(this.booleanValue));
                break;
            }
            case DOUBLE: {
                AttributeHandler.setCombatAttribute(easyNPC, this.attributeType, this.doubleValue);
                break;
            }
            default: {
                log.error("Invalid value type for {} for {} from {}", (Object)this.attributeType, easyNPC, (Object)serverPlayer);
            }
        }
    }
}

