/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean booleanValue, Float floatValue, Integer integerValue, String stringValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_entity_attribute");

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean value) {
        this(uuid, entityAttribute, value, Float.valueOf(0.0f), 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Float value) {
        this(uuid, entityAttribute, false, value, 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Integer value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), value, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, String value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), 0, value);
    }

    public static ChangeEntityAttributeMessage create(class_2540 buffer) {
        return new ChangeEntityAttributeMessage(buffer.method_10790(), (EntityAttribute)buffer.method_10818(EntityAttribute.class), buffer.readBoolean(), Float.valueOf(buffer.readFloat()), buffer.readInt(), buffer.method_19772());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.entityAttribute);
        buffer.writeBoolean(this.booleanValue.booleanValue());
        buffer.writeFloat(this.floatValue.floatValue());
        buffer.writeInt(this.integerValue.intValue());
        buffer.method_10814(this.stringValue);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.entityAttribute == null) {
            log.error("Invalid entity attribute for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.floatValue == null && this.integerValue == null && this.stringValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.entityAttribute, easyNPC, (Object)serverPlayer);
            return;
        }
        boolean successfullyChanged = false;
        if (this.booleanValue != null) {
            successfullyChanged = AttributeHandler.setEntityAttribute(easyNPC, this.entityAttribute, this.booleanValue);
        }
        if (!successfullyChanged) {
            log.error("Unable to change entity attribute {} for {} from {}", (Object)this.entityAttribute, easyNPC, (Object)serverPlayer);
        }
    }
}

