/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeEntityBaseAttributeMessage(UUID uuid, class_2960 attribute, Double value) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_entity_base_attribute");

    public static ChangeEntityBaseAttributeMessage create(class_2540 buffer) {
        return new ChangeEntityBaseAttributeMessage(buffer.method_10790(), buffer.method_10810(), buffer.readDouble());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10812(this.attribute);
        buffer.writeDouble(this.value.doubleValue());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.attribute == null) {
            log.error("Invalid base attribute for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.value == null) {
            log.error("Invalid value for base attribute {} for {} from {}", (Object)this.attribute, easyNPC, (Object)serverPlayer);
            return;
        }
        if (!AttributeHandler.setBaseAttribute(easyNPC, this.attribute, this.value)) {
            log.error("Unable to set base attribute {} for {} from {}", (Object)this.attribute, easyNPC, (Object)serverPlayer);
        }
    }
}

