/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeModelEquipmentVisibilityMessage(UUID uuid, class_1304 equipmentSlot, boolean visible) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_model_equipment_visibility");

    public static ChangeModelEquipmentVisibilityMessage create(class_2540 buffer) {
        return new ChangeModelEquipmentVisibilityMessage(buffer.method_10790(), (class_1304)buffer.method_10818(class_1304.class), buffer.readBoolean());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.equipmentSlot);
        buffer.writeBoolean(this.visible);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.equipmentSlot == null) {
            log.error("Invalid equipmentSlot for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.equipmentSlot, (Object)this.visible, easyNPC, (Object)serverPlayer);
        switch (this.equipmentSlot) {
            case field_6169: {
                modelData.setModelHelmetVisible(this.visible);
                break;
            }
            case field_6174: {
                modelData.setModelChestplateVisible(this.visible);
                break;
            }
            case field_6172: {
                modelData.setModelLeggingsVisible(this.visible);
                break;
            }
            case field_6166: {
                modelData.setModelBootsVisible(this.visible);
                break;
            }
            default: {
                log.error("Invalid equipmentSlot {} for {} from {}", (Object)this.equipmentSlot, easyNPC, (Object)serverPlayer);
            }
        }
    }
}

