/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeProfessionMessage(UUID uuid, Profession profession) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_profession");

    public static ChangeProfessionMessage create(class_2540 buffer) {
        return new ChangeProfessionMessage(buffer.method_10790(), (Profession)buffer.method_10818(Profession.class));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.profession);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.profession == null) {
            log.error("Invalid profession for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ProfessionData<?> professionData = easyNPC.getEasyNPCProfessionData();
        if (professionData == null) {
            log.error("Invalid profession data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change profession {} for {} from {}", (Object)this.profession, easyNPC, (Object)serverPlayer);
        professionData.setProfession(this.profession);
    }
}

