/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeScaleMessage(UUID uuid, ModelScaleAxis scaleAxis, Float scaleValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "change_scale");

    public static ChangeScaleMessage create(class_2540 buffer) {
        return new ChangeScaleMessage(buffer.method_10790(), (ModelScaleAxis)buffer.method_10818(ModelScaleAxis.class), Float.valueOf(buffer.readFloat()));
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.scaleAxis);
        buffer.writeFloat(this.scaleValue.floatValue());
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.scaleAxis == null) {
            log.error("Invalid scale axis request for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.scaleValue == null || this.scaleValue.floatValue() < 0.1f || this.scaleValue.floatValue() > 10.0f) {
            log.error("Invalid scale {} request for UUID {} from {}", (Object)this.scaleValue, easyNPC, (Object)serverPlayer);
            return;
        }
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        if (scaleData == null) {
            log.error("Invalid scale data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        scaleData.setModelScaleAxis(this.scaleAxis, this.scaleValue);
    }
}

