/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record RemoveDialogMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc", "remove_dialog");

    public static RemoveDialogMessage create(class_2540 buffer) {
        return new RemoveDialogMessage(buffer.method_10790(), buffer.method_10790());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(class_3222 serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown delete dialog request for dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            return;
        }
        if (dialogData.removeDialog(this.dialogId)) {
            log.info("Removed dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        } else {
            log.warn("Unable to remove dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        }
    }
}

