/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.DialogArgument;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class DialogCommand
extends Command {
    private DialogCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dialog").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"default").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"dialog", (ArgumentType)DialogArgument.uuidOrLabel()).executes(context -> DialogCommand.setDefaultDialog((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), DialogArgument.getUuidOrLabel((CommandContext<class_2168>)context, "dialog")))))))).then(class_2170.method_9247((String)"open").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> DialogCommand.openDialog((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2186.method_9315((CommandContext)context, (String)"player")))).then(class_2170.method_9244((String)"dialog", (ArgumentType)DialogArgument.uuidOrLabel()).executes(context -> DialogCommand.openDialog((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2186.method_9315((CommandContext)context, (String)"player"), DialogArgument.getUuidOrLabel((CommandContext<class_2168>)context, "dialog")))))))).then(class_2170.method_9247((String)"close").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> DialogCommand.closeDialog((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
    }

    public static int setDefaultDialog(class_2168 context, EasyNPC<?> easyNPC, Pair<UUID, String> dialogPair) {
        if (dialogPair.getFirst() != null) {
            return DialogCommand.setDefaultDialog(context, easyNPC, (UUID)dialogPair.getFirst());
        }
        if (dialogPair.getSecond() != null) {
            return DialogCommand.setDefaultDialog(context, easyNPC, (String)dialogPair.getSecond());
        }
        return DialogCommand.sendFailureMessage(context, "Invalid dialog UUID or label!");
    }

    public static int setDefaultDialog(class_2168 context, EasyNPC<?> easyNPC, String dialogLabel) {
        if (!dialogLabel.isEmpty() && !easyNPC.getEasyNPCDialogData().hasDialog(dialogLabel)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with label " + dialogLabel + " for EasyNPC with UUID " + easyNPC.getUUID() + "!");
        }
        return DialogCommand.setDefaultDialog(context, easyNPC, easyNPC.getEasyNPCDialogData().getDialogId(dialogLabel));
    }

    public static int setDefaultDialog(class_2168 context, EasyNPC<?> easyNPC, UUID dialogUUID) {
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog(dialogUUID)) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        dialogDataSet.setDefaultDialog(dialogUUID);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Set default dialog for " + easyNPC + " to " + dialogUUID, class_124.field_1060);
    }

    public static int openDialog(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        if (!serverPlayer.method_5805()) {
            return DialogCommand.sendFailureMessage(context, "Player is death!");
        }
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog()) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        easyNPC.getEasyNPCDialogData().openDefaultDialog(serverPlayer);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Open dialog for " + easyNPC + " with " + serverPlayer, class_124.field_1060);
    }

    public static int openDialog(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer, Pair<UUID, String> dialogPair) {
        if (dialogPair.getFirst() != null) {
            return DialogCommand.openDialog(context, easyNPC, serverPlayer, (UUID)dialogPair.getFirst());
        }
        if (dialogPair.getSecond() != null) {
            return DialogCommand.openDialog(context, easyNPC, serverPlayer, (String)dialogPair.getSecond());
        }
        return DialogCommand.sendFailureMessage(context, "Invalid dialog UUID or label!");
    }

    public static int openDialog(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer, String dialogLabel) {
        if (!dialogLabel.isEmpty() && !easyNPC.getEasyNPCDialogData().hasDialog(dialogLabel)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with label " + dialogLabel + " for EasyNPC with UUID " + easyNPC.getUUID() + "!");
        }
        return DialogCommand.openDialog(context, easyNPC, serverPlayer, easyNPC.getEasyNPCDialogData().getDialogId(dialogLabel));
    }

    public static int openDialog(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer, UUID dialogUUID) {
        if (!serverPlayer.method_5805()) {
            return DialogCommand.sendFailureMessage(context, "Player is death!");
        }
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog()) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        if (!easyNPC.getEasyNPCDialogData().hasDialog(dialogUUID)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with UUID " + dialogUUID + " for EasyNPC with UUID " + easyNPC.getUUID() + "!");
        }
        easyNPC.getEasyNPCDialogData().openDialog(serverPlayer, dialogUUID);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Open dialog for " + easyNPC + " with " + serverPlayer + " and dialog " + dialogUUID, class_124.field_1060);
    }

    public static int closeDialog(class_2168 context, class_3222 serverPlayer) {
        serverPlayer.method_7346();
        return DialogCommand.sendSuccessMessage(context, "\u25ba Closed dialog screen for player " + serverPlayer, class_124.field_1054);
    }
}

