/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class NavigationCommand
extends Command {
    private static final String ARG_POSITION = "position";

    private NavigationCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"navigation").requires(cs -> cs.method_9259(0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)ARG_POSITION, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setHomePosition((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), coordinates.method_9708((class_2168)context.getSource()));
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pos").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)ARG_POSITION, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setPosition((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), coordinates.method_9708((class_2168)context.getSource()));
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> NavigationCommand.reset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")))));
    }

    private static int setHomePosition(class_2168 context, EasyNPC<?> easyNPC, class_243 position) {
        if (easyNPC == null || position == null || position.equals((Object)class_243.field_1353)) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        class_2338 blockPos = new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350);
        navigationData.setHomePosition(blockPos);
        return NavigationCommand.sendSuccessMessage(context, "Set home position for EasyNPC " + easyNPC + " with UUID " + easyNPC.getUUID() + " to " + blockPos);
    }

    private static int setPosition(class_2168 context, EasyNPC<?> easyNPC, class_243 position) {
        if (easyNPC == null || position == null || position.equals((Object)class_243.field_1353)) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.setPosition(position);
        return NavigationCommand.sendSuccessMessage(context, "Set position for EasyNPC " + easyNPC + " with UUID " + easyNPC.getUUID() + " to " + position);
    }

    private static int reset(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.getGroundPathNavigation().method_6356();
        return NavigationCommand.sendSuccessMessage(context, "Reset navigation for EasyNPC " + easyNPC);
    }
}

