/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.handler.OwnerHandler;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class OwnerCommand
extends Command {
    private static final String EASY_NPC_PREFIX = "EasyNPC ";

    private OwnerCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"owner").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> OwnerCommand.setOwner((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2186.method_9315((CommandContext)context, (String)"player"))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> OwnerCommand.getOwner((class_2168)context.getSource(), EasyNPCArgument.getEntity((CommandContext<class_2168>)context, "npc_target")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> OwnerCommand.removeOwner((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")))));
    }

    private static int setOwner(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        if (easyNPC == null || serverPlayer == null) {
            return 0;
        }
        if (!OwnerHandler.setOwner(easyNPC, (class_1309)serverPlayer)) {
            OwnerCommand.sendFailureMessage(context, "Failed to set owner for " + easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, "Owner of " + easyNPC + " was changed to " + serverPlayer);
    }

    private static int getOwner(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null) {
            return OwnerCommand.sendFailureMessageNoOwnerData(context, easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, EASY_NPC_PREFIX + easyNPC.getUUID() + " is owned by " + ownerData.method_35057());
    }

    private static int removeOwner(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        if (!OwnerHandler.removeOwner(easyNPC)) {
            return OwnerCommand.sendFailureMessage(context, "Failed to remove owner for " + easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, "Owner of " + easyNPC + " was removed.");
    }
}

