/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.PresetSuggestions;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class PresetCommand
extends Command {
    private static final String COMMAND_NAME = "preset";
    private static final String CUSTOM_ARG = "custom";
    private static final String DATA_ARG = "data";
    private static final String DEFAULT_ARG = "default";
    private static final String EXPORT_ARG = "export";
    private static final String IMPORT_ARG = "import";
    private static final String IMPORT_NEW_ARG = "import_new";
    private static final String IMPORT_WITH_OWNER_ARG = "import_with_owner";
    private static final String LOCAL_ARG = "local";
    private static final String LOCATION_ARG = "location";
    private static final String PRESET_ARG = "preset";
    private static final String NAME_ARG = "name";
    private static final String UUID_ARG = "uuid";
    private static final String WORLD_ARG = "world";

    private PresetCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"preset").requires(cs -> cs.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)EXPORT_ARG).then(class_2170.method_9247((String)LOCAL_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportLocalPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), null))).then(class_2170.method_9244((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportLocalPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG))))))).then(class_2170.method_9247((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportCustomPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), null))).then(class_2170.method_9244((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportCustomPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG))))))).then(class_2170.method_9247((String)WORLD_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportWorldPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), null))).then(class_2170.method_9244((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportWorldPreset((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)IMPORT_ARG).then(class_2170.method_9247((String)LOCAL_ARG).executes(context -> PresetCommand.importLocalPreset((class_2168)context.getSource())))).then(class_2170.method_9247((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestCustom).executes(context -> PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), null, null);
        })).then(class_2170.method_9244((String)UUID_ARG, (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)UUID_ARG);
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), uuid, null);
        })))))).then(class_2170.method_9247((String)DATA_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestData).executes(context -> PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), null, null);
        })).then(class_2170.method_9244((String)UUID_ARG, (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)UUID_ARG);
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), uuid, null);
        })))))).then(class_2170.method_9247((String)DEFAULT_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestDefault).executes(context -> PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), null, null);
        })).then(class_2170.method_9244((String)UUID_ARG, (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)UUID_ARG);
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), uuid, null);
        })))))).then(class_2170.method_9247((String)WORLD_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestWorld).executes(context -> PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), null, null);
        })).then(class_2170.method_9244((String)UUID_ARG, (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)UUID_ARG);
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), uuid, null);
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)IMPORT_NEW_ARG).then(class_2170.method_9247((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestCustom).executes(context -> PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), null);
        }))))).then(class_2170.method_9247((String)DATA_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestData).executes(context -> PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), null);
        }))))).then(class_2170.method_9247((String)DEFAULT_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestDefault).executes(context -> PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), null);
        }))))).then(class_2170.method_9247((String)WORLD_ARG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestWorld).executes(context -> PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), null);
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)IMPORT_WITH_OWNER_ARG).then(class_2170.method_9247((String)CUSTOM_ARG).then(class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestCustom).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), class_2186.method_9315((CommandContext)context, (String)"player"));
        })))))).then(class_2170.method_9247((String)DATA_ARG).then(class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestData).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), class_2186.method_9315((CommandContext)context, (String)"player"));
        })))))).then(class_2170.method_9247((String)DEFAULT_ARG).then(class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestDefault).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), class_2186.method_9315((CommandContext)context, (String)"player"));
        })))))).then(class_2170.method_9247((String)WORLD_ARG).then(class_2170.method_9244((String)"preset", (ArgumentType)class_2232.method_9441()).suggests(PresetSuggestions::suggestWorld).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)LOCATION_ARG, (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_2267 coordinates = class_2277.method_9734((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"preset"), coordinates.method_9708((class_2168)context.getSource()), UUID.randomUUID(), class_2186.method_9315((CommandContext)context, (String)"player"));
        }))))));
    }

    private static int importCustomPreset(class_2168 context, class_2960 preset, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importCustomPreset(context.method_9225(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(CUSTOM_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(CUSTOM_ARG, preset, position, uuid));
    }

    private static int importDataPreset(class_2168 context, class_2960 preset, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importDataPreset(context.method_9225(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(DATA_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(DATA_ARG, preset, position, uuid));
    }

    private static int importDefaultPreset(class_2168 context, class_2960 preset, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importDefaultPreset(context.method_9225(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(DEFAULT_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(DEFAULT_ARG, preset, position, uuid));
    }

    private static int importLocalPreset(class_2168 context) {
        return PresetCommand.sendFailureMessage(context, "Importing a local preset from the server is not supported!");
    }

    private static int importWorldPreset(class_2168 context, class_2960 preset, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importWorldPreset(context.method_9225(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(WORLD_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(WORLD_ARG, preset, position, uuid));
    }

    private static String importedPresetFailedMessage(String presetType, class_2960 preset) {
        return "Unable to import " + presetType + " preset " + preset + " !";
    }

    private static String importedPresetMessage(String presetType, class_2960 preset, class_243 position, UUID uuid) {
        return "Imported " + presetType + " preset " + preset + (String)(position != null ? " at " + position : "") + (String)(uuid != null ? " with UUID " + uuid : "") + " !";
    }

    private static int exportCustomPreset(class_2168 context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null) {
            return 0;
        }
        if (!PresetHandler.exportCustomPreset(easyNPC, name)) {
            return PresetCommand.sendFailureMessage(context, "Unable to export custom preset for " + easyNPC + "!");
        }
        return PresetCommand.sendSuccessMessage(context, "Exporting custom preset " + name + " for " + easyNPC + " with UUID " + easyNPC.getUUID() + "!");
    }

    private static int exportWorldPreset(class_2168 context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null) {
            return 0;
        }
        if (!PresetHandler.exportWorldPreset(easyNPC, name)) {
            return PresetCommand.sendFailureMessage(context, "Unable to export world preset for " + easyNPC + "!");
        }
        return PresetCommand.sendSuccessMessage(context, "Exporting world preset " + name + " for " + easyNPC + " with UUID " + easyNPC.getUUID() + "!");
    }

    private static int exportLocalPreset(class_2168 context, EasyNPC<?> easyNPC, String name) {
        class_3222 serverPlayer;
        if (easyNPC == null) {
            return 0;
        }
        try {
            serverPlayer = context.method_9207();
        }
        catch (CommandSyntaxException e) {
            return PresetCommand.sendFailureMessage(context, "This command can only be executed by a player!");
        }
        String presetFileName = CustomPresetDataFiles.getPresetFileName(name != null && !name.isEmpty() ? name : easyNPC.getUUID().toString());
        NetworkMessageHandlerManager.getClientHandler().exportClientPreset(easyNPC.getUUID(), presetFileName, serverPlayer);
        return PresetCommand.sendSuccessMessage(context, "Exporting EasyNPC " + easyNPC.getEntity().method_5476().getString() + " locally to config/easy_npc/preset/" + easyNPC.getEasyNPCSkinData().getSkinModel().getName() + "/" + presetFileName + " !");
    }
}

